/*
 *	cook - file construction tool
 *	Copyright (C) 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: functions to implement builtin word function
 */

#include <ctype.h>

#include <builtin/word.h>
#include <expr.h>


static long number _((char *));

static long
number(s)
	char		*s;
{
	long		n;

	n = 0;
	while (isspace(*s))
		++s;
	while (isdigit(*s))
		n = n * 10 + *s++ - '0';
	while (isspace(*s))
		++s;
	if (*s)
		return 0;
	return n;
}


int
builtin_word(result, arg)
	wlist		*result;
	wlist		*arg;
{
	long		n;

	if (arg->wl_nwords < 2)
	{
		expr_error
		(
			"%s: requires at least one argument",
			arg->wl_word[0]->str_text
		);
		return -1;
	}
	n = number(arg->wl_word[1]->str_text);
	if (n <= 0)
	{
		expr_error
		(
			"%s: first argument must be a positive decimal number",
			arg->wl_word[0]->str_text
		);
		return -1;
	}
	if (n + 1 < arg->wl_nwords)
		wl_append(result, arg->wl_word[n + 1]);
	return 0;
}
