/*
 *	cook - file construction tool
 *	Copyright (C) 1990, 1991, 1992, 1993, 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: interface definition for cook/cook.c
 */

#ifndef COOK_H
#define COOK_H

#include <ac/time.h>

#include <expr.h>
#include <stmt.h>

extern int desist;


typedef struct recipe recipe;
struct	recipe
{
	wlist		r_target;
	elist		r_need;
	elist		r_need2;
	int		r_flags;
	stmt		*r_action;
	stmt		*r_use_action;
	int		r_tag;		/* for tracing and debugging */
	expr		*r_precondition;
	int		r_multiple;
	int		inhibit;
};

typedef struct rlist rlist;
struct	rlist
{
	size_t		rl_nrecipes;
	recipe		*rl_recipe;
};

extern	rlist	explicit;
extern	rlist	implicit;

/*
 *  r_flags values
 */
#define RF_CLEARSTAT		((unsigned long)1 <<  0)
#define RF_CLEARSTAT_OFF	((unsigned long)1 <<  1)
#define RF_DEFAULT		((unsigned long)1 <<  2)
#define RF_DEFAULT_OFF		((unsigned long)1 <<  3)
#define RF_ERROK		((unsigned long)1 <<  4)
#define RF_ERROK_OFF		((unsigned long)1 <<  5)
#define RF_FINGERPRINT		((unsigned long)1 <<  6)
#define RF_FINGERPRINT_OFF	((unsigned long)1 <<  7)
#define RF_FORCE		((unsigned long)1 <<  8)
#define RF_FORCE_OFF		((unsigned long)1 <<  9)
#define RF_METER		((unsigned long)1 << 10)
#define RF_METER_OFF		((unsigned long)1 << 11)
#define RF_PRECIOUS		((unsigned long)1 << 12)
#define RF_PRECIOUS_OFF		((unsigned long)1 << 13)
#define RF_SILENT		((unsigned long)1 << 14)
#define RF_SILENT_OFF		((unsigned long)1 << 15)
#define RF_UPDATE		((unsigned long)1 << 16)
#define RF_UPDATE_OFF		((unsigned long)1 << 17)
#define RF_STRIPDOT		((unsigned long)1 << 18)
#define RF_STRIPDOT_OFF		((unsigned long)1 << 19)

int cook _((wlist *));
void rl_append _((rlist *, recipe *));
void cook_flags _((int, int));
int recipe_tag _((void));
int isit_uptodate _((string_ty *));
int cando _((string_ty *));
time_t cook_mtime_oldest _((string_ty *path, long *depth_p));
time_t cook_mtime_newest _((string_ty *path, long *depth_p));
int cook_mtime_resolve _((wlist *, wlist *, int));

void cook_auto _((wlist *));
int cook_auto_required _((void));
void cook_reset _((void));
void cook_find_default _((wlist *));

#endif /* COOK_H */
