/*
 *	cook - file construction tool
 *	Copyright (C) 1990, 1991, 1992, 1993 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: interface definition for cook/stmt.c
 */

#ifndef STMT_H
#define STMT_H

#include <main.h>
#include <str.h>
#include <expr.h>

/*
 * s_op values
 */
enum stmt_op_ty
{
	OP_ASSIGN = 1,
	OP_COMMAND,
	OP_COMPOUND,
	OP_FAIL,
	OP_FAIL_DK,
	OP_IF,
	OP_LOOP,
	OP_LOOPSTOP,
	OP_NOP,
	OP_RECIPE,
	OP_SET,
	OP_TOUCH,
	OP_UNSETENV
};
typedef enum stmt_op_ty stmt_op_ty;

typedef struct assign assign;
struct assign
{
	elist		a_name;
	elist		a_value;
};

typedef struct slist slist;
struct slist
{
	size_t		sl_nstmts;
	struct stmt	**sl_stmt;
};

typedef struct srecipe srecipe;
struct srecipe
{
	elist		sr_target;
	elist		sr_need;
	elist		sr_need2;
	int		sr_flags;
	struct stmt	*sr_action;
	struct stmt	*sr_use_action;
	position	sr_position;
	expr		*sr_precondition;
	int		sr_multiple;
};

typedef struct command command;
struct command
{
	elist		c_args;
	int		c_flags;
	expr		*c_input;
};

typedef struct sif sif;
struct sif
{
	expr		*sif_cond;
	struct stmt	*sif_true;
	struct stmt	*sif_false;
};

typedef struct stmt stmt;
struct stmt
{
	stmt_op_ty	s_op;
	long		s_references;
	union
	{
		assign		s__assign;
		command		s__cmd;
		slist		s__list;
		sif		s__if;
		stmt		*s__loop;
		srecipe		s__recipe;
		expr		*s__include;
	}
		s__u;
};
#define s_assign	s__u.s__assign
#define s_cmd		s__u.s__cmd
#define s_if		s__u.s__if
#define s_list		s__u.s__list
#define s_loop		s__u.s__loop
#define s_recipe	s__u.s__recipe
#define s_include	s__u.s__include

/*
 * return values for stmt_eval()
 */
#define STMT_OK		0
#define STMT_LSTOP	-1
#define STMT_RET	-2
#define STMT_ERROR	-3
#define STMT_BACKTRACK -4

stmt *stmt_alloc _((void));
stmt *stmt_copy _((stmt *));
void stmt_free _((stmt *));
int stmt_eval _((stmt *));
void sl_append _((slist *, stmt *));
void sl_free _((slist *));
void sl_zero _((slist *));

#endif /* STMT_H */
