/*
 *	cook - file construction tool
 *	Copyright (C) 1993, 1994 Peter Miller.
 *	All rights reserved.
 *
 *	This program is free software; you can redistribute it and/or modify
 *	it under the terms of the GNU General Public License as published by
 *	the Free Software Foundation; either version 2 of the License, or
 *	(at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *	GNU General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License
 *	along with this program; if not, write to the Free Software
 *	Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 * MANIFEST: operating system start-up point
 */

#include <stdio.h>
#include <ac/stdlib.h>

#include <arglex.h>
#include <error.h>
#include <str.h>
#include <trace.h>
#include <txt2c.h>
#include <version-stmp.h>


static void usage _((void));

static void
usage()
{
	fprintf
	(
		stderr,
		"usage: %s [ <infile> [ <outfile> ]]\n",
		progname
	);
	exit(1);
}


static arglex_table_ty argtab[] =
{
	{ 0, (arglex_token_ty)0, }, /* end marker */
};


int main _((int, char **));

int
main(argc, argv)
	int	argc;
	char	**argv;
{
	char	*infile;
	char	*outfile;

	str_initialize();
	arglex_init(argc, argv, argtab);
	infile = 0;
	outfile = 0;
	arglex();
	while (arglex_token != arglex_token_eoln)
	{
		switch (arglex_token)
		{
		default:
			error
			(
				"misplaced \"%s\" command line argument",
				arglex_value.alv_string
			);
			usage();

		case arglex_token_help:
			fatal
			(
"This command is for constructing cook, it is not for general use.  \
The -Help option is therefore not supported for this command."
			);

		case arglex_token_string:
			if (!infile)
				infile = arglex_value.alv_string;
			else if (!outfile)
				outfile = arglex_value.alv_string;
			else
				fatal("too many file names specified");
			break;

		case arglex_token_stdio:
			if (!infile)
				infile = "";
			else if (!outfile)
				outfile = "";
			else
				fatal("too many file names specified");
			break;

#ifdef DEBUG
		case arglex_token_tracing:
			while (arglex() == arglex_token_string)
				trace_enable(arglex_value.alv_string);
			continue;
#endif
		}
		arglex();
	}
	if (infile && !*infile)
		infile = 0;
	if (outfile && !*outfile)
		outfile = 0;

	txt2c(infile, outfile);
	exit(0);
	return 0;
}


char *
version_stamp()
{
	return "!#$@&*!";
}
