/*
\funcref{main}{void main (\params)}
    {
        {int} {argc} {argument count}
        {char} {**argv} {pointer to array of argument strings}
    }
    {}
    {error(), pushfile(), lexer(), process()}
    {}
    {icm-pp.c}
    {
        Function {\em main()} checks if two arguments are present on the
        invoking command line. If not, an error occurs.

        The environment variable {\em IM} is inspected to ensure that
        included files are searched from this directory. When not set,
        included files are searched in the current directory.

        Next the input- and output files are opened. The input file is opened
        using function {\em pushfile()}. The output file is pointed to by {\em
        FILE $*$outfile}.

        To process the input, function {\em lexer()} is called and its return
        value is passed to {\em process()}. This is repeated until the
        filestack pointer {\em filesp} (increased by {\em pushfile()},
        decreased by {\em popfile()}) indicates that the file stack is empty.
    }
*/


#ifdef MSDOS
#    define LIBREQUEST
#    pragma comment (lib, "icmpp")
#    pragma comment (lib, "../rss/icrss")
#endif

#include "icm-pp.h"

void main (int argc, char **argv)
{
    register char
        *progname;

    if (argc != 3)
    {
        copyright ("ICMAKE Preprocessor", version, release, 1);
        progname = program_name (argv [0]);
        printf ("This program is run as a child process of icmake.\n"
                "Usage: %s inputfile outputfile\n"
                "where: inputfile  - makefile in text format\n"
                "       outputfile - result of preprocessing\n\n"
            , progname);
        exit (1);
    }

    if (! (imdir = getenv ("IM")) )
        imdir = ".";

    if (! (outfile = fopen (argv [2], "w")) )
        error ("cannot open input file %s", argv [2]);
    pushfile (argv [1]);

    loadsym();                              /* platform specific #define's */

    while (filesp >= 0)
        process (lexer ());

    exit (0);
}
