/*
 *  cxfir.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */

#ifndef CXFIR_DOT_H
#define CXFIR_DOT_H

#include "ObjProDSP/portable.h"
#include "ObjProDSP/entenm.h"
#include "ObjProGen/debug.h"
#include "ObjProUsr/procnode.h"

class CxFir: public ProcessNode {
#line 111 "../cxfir.usr"
 
	virtual void clear_buffers(){
		NextSampleToWrite = 0;
		DemodIndex = 0 ;
		ValidData = 0;
		ZeroPadIndex = 0 ;
	}
	CxMachWord * DataBuf ;
	int32 DataBufSize ;
	int32 FilterLength ;
	int Demod ;
	int32 DemodIndex ;
	complex DemodPhase ;
	complex DemodDeltaPhase ;
	int32 NextSampleToWrite ;
	int32 ValidData ;
	int32 ZeroPadIndex ;
#line 38 "/usrb/dist/ftp/opd-0.1/src/include/ObjProDSPint/ObjProUsr/cxfir.h"
	int16  Resample_1;
	int16  ZeroPad_2;
	double  DemodFreq_3;
	int16  Odd_4;
	MachWord *  Coeff_5;
	int32 Coeff_Length_6;
public:
	CxFir (const char * Name, int16 Resample, int16 ZeroPad, double DemodFreq, 
		int16 Odd, MachWord * Coeff, int32 Coeff_Length);
	virtual ~CxFir();
	int16 GetResample() const {return Resample_1;}
	int16 GetZeroPad() const {return ZeroPad_2;}
	double GetDemodFreq() const {return DemodFreq_3;}
	int16 GetOdd() const {return Odd_4;}
	MachWord * GetCoeff() const {return Coeff_5;}
	int32 GetCoeff_Length() const {return Coeff_Length_6;}
	virtual int CheckSafeDelete() ;
	virtual ErrCode DoNode(int32);
	void Describe(OutTokens& Out, ListEntity Option);
	virtual int CppList(OutTokens& Out, CppListCmds Cmd);
};

extern CxFir * CxFirDef;

	extern MachWordType TheDataForCxFirCoeffDefaultArray[];


#endif /* #ifdef CXFIR_DOT_H */
