/*
 *  stdyac.C from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software, All rights reserved.
 *  Licensed for free use and distribution under version 2 of the Gnu General
 *  Public License. Please see file COPYING for details and restrictions.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#include <iostream.h>
#include <string.h>
#include "stdyac.h"
#include "stdyacp.h"

const char * CurrentFileName = "<stdio>" ;
int LineNumber = 1;
int ErrorCount = 0;
static WarnCount = 0;
int (*EndOfFileFound)() = 0;


void OutWhereX(int End, ostream& Stream)
{
	Stream << " at line " << LineNumber << " in \""
		<< CurrentFileName << "\"" ;
	if (End) Stream << ".\n" ;
	else Stream << " " ;
}

void OutWhere(ostream& Stream)
{
	OutWhereX(0,Stream);
}

void Found(const char * Msg)
{
	// cerr << "Found `" << Msg <<"' at line " << LineNumber << ".\n" ;
}

// interface to pure C code in Lex output
void OutWhereC()
{
	OutWhere();
}

void OutWhereEndC()
{
	OutWhereEnd();
}

void IllegalChar(char C)
{
	cerr << "Illegal character `" ;
	cerr.put(C);
	cerr << "' ( 0x" << hex << (short) C << dec <<")"  ;
	OutWhereEnd() ;
}

void YaccWarning(const char * s0,const char * s1,const char *s2,
	const char * s3,const char *s4)
{
	cerr << "Warning: " << s0 ;
	if (s1) cerr << s1 ;
	if (s2) cerr << s2 ;
	if (s3) cerr << s3 ;
	if (s4) cerr << s4 ;
	OutWhereEnd() ;
	++WarnCount ;
}


void yyerror(const char * s0,const char * s1,const char *s2,
	const char * s3,const char *s4)
{
	cerr << "Error: " << s0 ;
	if (s1) cerr << s1 ;
	if (s2) cerr << s2 ;
	if (s3) cerr << s3 ;
	if (s4) cerr << s4 ;
	OutWhereEnd() ;
	++ErrorCount ;
}


const char * MakeName(const char * Str)
{
	// cerr << "MakeName:: " << Str << "\n" ;
	return strcpy(new char[strlen(Str)+1],Str) ;
}

const char * MakeWordString(const char * Str)
{
	// cerr << "MakeWordString:: " << Str << "\n" ;
	char * Ret = strcpy(new char[strlen(Str)+1],Str) ;
	char * Wrt = Ret ;
	int LastCharacterBlank = 0;
	for (char * Read = Ret ; *Read ; Read++ ) {
		char Next = *Read ;
		if ( Next == '\t') Next = ' ' ;
		if ( Next == ' ') {
			if (LastCharacterBlank) continue ;
			LastCharacterBlank = 1;
		} else LastCharacterBlank = 0 ;
		*Wrt++ = Next ;
	}
	*Wrt = '\0' ;
	return Ret ;
}


int yywrap()
{
	int Return = 1 ;
	if (PopFile()) return 0 ;
	if (EndOfFileFound) Return = (*EndOfFileFound)();
	// cerr << "yywrap called.\n" ;
	// EndOfFileFound = 0 ;
	return Return ;
}

int ParseMain()
{
	int Result = yyparse();
	Result |= ErrorCount ;
	if (!Result) cerr << "Parse was successful.\n" ;
	else cerr << "Parse failed.\n" ;
	if (ErrorCount) cerr << ErrorCount << " errors.\n" ;
	if (WarnCount) cerr << WarnCount << " warnings.\n" ;
	return (Result == 0) ;
}

