/*
 *  parammen.h from ObjectProDSP 0.1
 *  Copyright (C) 1994, Mountain Math Software. All rights reserved.
 *  
 *  This file is part of ObjectProDSP, a tool for Digital Signal
 *  Processing design, development and implementation. It is free
 *  software provided you use and distribute it under the terms of
 *  version 2 of the GNU General Public License as published
 *  by the Free Software Foundation. You may NOT distribute it or
 *  works derived from it or code that it generates under ANY
 *  OTHER terms.  In particular NONE of the ObjectProDSP system is
 *  licensed for use under the GNU General Public LIBRARY License.
 *  Mountain Math Software plans to offer a commercial version of
 *  ObjectProDSP for a fee. That version will allow redistribution
 *  of generated code under standard commercial terms.
 *  
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *  
 *  You should have received a copy of version 2 of the GNU General
 *  Public License along with this program. See file COPYING. If not
 *  or if you wish information on commercial versions and licensing
 *  write Mountain Math Software, P. O. Box 2124, Saratoga, CA 95070,
 *  USA, or send us e-mail at: support@mtnmath.com.
 *  
 *  You may also obtain the GNU General Public License by writing the
 *  Free Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
 *  USA.  However if you received a copy of this program without the
 *  file COPYING or without a copyright notice attached to all text
 *  files, libraries and executables please inform Mountain Math Software.
 *  
 *  ObjectProDSP is a trademark of Mountain Math Software.
 */
#ifndef PARAMMEN_DOT_H
#define PARAMMEN_DOT_H
#include "portable.h"
#include "slist.h"
union Value ;

enum ItemType {TypeInt, TypeDouble, TypeString, TypeName, TypeText,
	TypeTerm, TypeCompound, TypeDescription, TypeList, TypeParamFunc,
	TypeSize, TypeScaledType, TypeStackIndex, TypeParameterizedAction} ;


struct Double {
	double DblValue ;
	const char * String ;
	Double(double value, const char * string)
		{DblValue=value; String=string;}
	~Double() {delete (void *) String;}
	void Negate();
	void EmitValue(class ostream * Out) ;
} ;

union Object {
	const char * Str ;
	int32 Int ;
	Double * Dbl ;
	int Terminal ;
	struct Compound * Tree ;
	class CompoundList * List ;
	class ParameterizedAction * Action ;
	Object(const char * str) {Str = str;}
	Object(int32 num) {Int = num;}
	Object(Double * flt) {Dbl = flt;}
	Object(Compound *cmpd) {Tree = cmpd;}
	Object(CompoundList * list) {List = list;}
	Object(ParameterizedAction * action) {Action = action;}
	Object(){}
} ; 

struct Compound {
	ItemType Type ;
	Object Item ;
	Compound(ItemType typ, Object item) {Type=typ; Item=item; }
	~Compound();
	void EmitValue(ostream * Out);
} ;

class CompoundList: public SingleList {
public:
	ErrCode Insert(Compound *nt) {return SingleList::Insert(nt);}
	ErrCode Append(Compound *nt) {return SingleList::Append(nt);}
	Compound * Get()   {return (Compound *) SingleList::Get();}
	Compound * Pop() {return (Compound *) SingleList::Pop();}
	Compound * GetNFromTop(int N) ;
	Compound * GetNthEntry(int N) ;
	CompoundList(){}
	CompoundList(Compound * obj) {Append(obj);}
	~CompoundList();
	int Size(){return SingleList::Size();}
} ;

class CompoundListIterator: public SingleListIterator {
public:
	CompoundListIterator(CompoundList& df):
		SingleListIterator((SingleList&) df){}
	Compound * operator()()
		{return (Compound *) Next();}
};

struct ParameterizedAction {
	class CompoundList * List ;
	const char * Name ;
	const char * RemoteName ;
	int ParameterSequenceIndex ;
	int wait_flag:1 ;
	ParameterizedAction(const char * name, CompoundList * list, int index,
		int wait = 0 );
	~ParameterizedAction() {delete List;}
	int IsIdentical(ParameterizedAction *);
	const char * GetRemoteName() {return RemoteName;}
	const char * GetName() {return Name;}
	CompoundList * GetList() {return List;}
	void MakeCompoundName();
};


class ParameterizedActionList: public SingleList {
public:
	ErrCode Insert(ParameterizedAction *nt) {return SingleList::Insert(nt);}
	ErrCode Append(ParameterizedAction  *nt)
		{return SingleList::Append(nt);}
	ParameterizedAction * Get()
		{return (ParameterizedAction  *) SingleList::Get();}
	ParameterizedActionList(){}
	void Clear();
	~ParameterizedActionList() {} // {Clear();}
	int Size(){return SingleList::Size();}
	void CheckAndAppend(ParameterizedAction * nt);
} ;



class ParameterizedActionListIterator: public SingleListIterator {
public:
	ParameterizedActionListIterator(ParameterizedActionList& df):
		SingleListIterator((SingleList&) df){}
	ParameterizedAction * operator()()
		{return (ParameterizedAction *) Next();}
};



Compound * MakeParameterList(Compound *Cm=0, Compound * Cmp=0);

Compound * MakeParameter(const char *);
Compound * MakeStackParameter(int);

Compound * MakeNumber(int);
Compound * MakeNumber(Double *);

Compound * MakeNegNumber(int);
Compound * MakeNegNumber(Double *);

Value * FoundItemTemplate(Compound *Act,Value *Typ,
	const char * HelpReference, Value *Init, Value *Str,
	class TextFragmentList * Help,const char * HelpFile) ;

Value * FoundMenuItem(Value *Cmd,Compound *Act,Value *Typ,
	const char * HelpReference, Value *Init, Value *Str,
	class TextFragmentList * Help,const char * HelpFile) ;

Compound * MakeActionValue(const char *, CompoundList * List=0, int wait=0);
Compound * MakeActionValue(Value *,Compound *,int wait = 0);

extern const char * Template ;

void OutMenuCalls(ParameterizedActionList ** AllFunctions, const char * ExeFile,
	int RemoteFlag=0);

#endif /* #ifdef PARAMMEN_DOT_H */
