/* Test console library
*/

		 /*******************************
		 *		TEST		*
		 *******************************/
#include <windows.h>

#define IOSTREAM_REPLACES_STDIO 1
#include <stdio.h>
#include "stream.h"
#include "console.h"
#include <malloc.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <dirent.h>

#define streq(s, q) (strcmp((s), (q)) == 0)


void
hello(int sig)
{ printf("Hello\n");
  fprintf(stderr, "Caught signal %d\n", sig);
}


void
warn(char *buf)
{ fprintf(stderr, "Don't understand `%s'\n", buf);
}


void
read_file(char *name)
{ FILE *fd = fopen(name, "rb");

  if ( fd )
  { int c;
    int n = 0;
    clock_t s, e;

    s = clock();
    while((c=getc(fd)) != EOF)
      n++;
    e = clock();

    fprintf(stdout, "Read %d characters in %2f seconds\n",
	    n, (float)(e-s)/(float)CLOCKS_PER_SEC);
    fclose(fd);
  } else
    fprintf(stdout, "Can't open %s\n", name);
}


/*  $Id: memmodel.c,v 1.3 1995/02/13 14:56:46 jan Exp $

    Copyright (c) 1991 Jan Wielemaker. All rights reserved.
    jan@swi.psy.uva.nl

    Purpose: Determine machines memory-model
*/

/* - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
This program   was written  to  determine the  memory  model   of your
machine.  It may be used when writing a new md-machine.h file.

Compile this file using:

	% cc -o m-model m-model.c
	% ./m-model
	Memory layout:

		Text at 0x2290
		Global variable at 0x40d0
		Local variable at 0xeffff938
		malloc() at 0x61a0
		C-Stack grows Downward

	No special declarations needed in "md.h"

	%
- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - */

#define K * 1024
#define MAX_DECL 100

#define VERBOSE 1

int	global_var;

char *
sub()
{ char buf[10];

  return buf;
}

memmodel()
{ char buf[10];
  unsigned long gva = (unsigned long) &global_var;
  int stack_up = (sub() > buf);
  char *decl[MAX_DECL];
  int ndecl = 0;

#ifdef VERBOSE
  printf("Memory layout:\n\n");
  printf("\tText at 0x%x\n", sub);
  printf("\tGlobal variable at 0x%x\n", gva);
  printf("\tLocal variable at 0x%x\n", buf);
  printf("\tmalloc() at 0x%x\n", malloc(10));
  printf("\tC-Stack grows %sward\n", stack_up ? "Up" : "Down");
#endif	 

  if      ( (gva & 0xf0000000L) == 0x80000000L )
    decl[ndecl++] = "DATA_AT_0X8=1;";
  else if ( (gva & 0xf0000000L) == 0x40000000L )
    decl[ndecl++] = "DATA_AT_0X4=1;";
  else if ( (gva & 0xf0000000L) == 0x20000000L )
    decl[ndecl++] = "DATA_AT_0X2=1;";
  else if ( (gva & 0xf0000000L) == 0x10000000L )
    decl[ndecl++] = "DATA_AT_0X1=1;";
  else if ( (gva & 0xf0000000L) )
  { printf("PROBLEM: Memory model not supported; see \"pl-incl.h\"\n");
    exit(1);
  }
  
  if ( stack_up )
    decl[ndecl++] = "STACK_DIRECTION=1;";
  else
    decl[ndecl++] = "STACK_DIRECTION=-1;";

  if ( !malloc(200000) )
  { printf("PROBLEM: malloc(200000) fails; see \"pl-os.c\"\n");
    return 1;
  }

  if ( ndecl > 0 )
  { int n;

    for(n=0; n<ndecl; n++)
      printf("%s\n", decl[n]);
  }

  return 0;
}


testmain(int argc, char **argv)
{ char buf[1024];
  int n;

  signal(SIGINT, hello);

  fprintf(stdout, "welcome to console\n\n");
  printf("Argc = %d:", argc);
  for(n=0; n<argc; n++)
    printf(" %s", argv[n]);
  printf("\n\n");

  for(;;)
  { char name[256];

    printf("console> ");
    fflush(stdout);
    
    if ( !gets(buf) )
      return 0;

    if ( sscanf(buf, "read %s", name) == 1 )
      read_file(name);
    else if ( sscanf(buf, "ls %s", name) == 1 )
    { DIR *d;

      if ( (d = opendir(name)) )
      { struct dirent *di;

	while( (di = readdir(d)) )
	{ printf("%s\n", di->d_name);
	}

	closedir(d);
      }
    } else if ( streq(buf, "memmodel") )
    { memmodel();
    } else
      warn(buf);
  }
}

		 /*******************************
		 *	       MAIN		*
		 *******************************/

IOSTREAM *S__iob;

int PASCAL
WinMain(HANDLE hInstance, HANDLE hPrevInstance,
	LPSTR lpszCmdLine, int nCmdShow)
{ S__iob = S__getiob();

  return rlc_main(hInstance, hPrevInstance, lpszCmdLine, nCmdShow, testmain);
}
