/* Copyright 1994 Brad Pitzel

   Feel free to use/distribute/modify as long as proper credits
   are included.
*/

/*
  This little program shows how to use the SoundIt libraruy
*/

#include <stdlib.h>
#include <stdio.h>

/* these 3 are for the vga_getkey() */
#include <termios.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "soundIt.h"

#define NUM_SAMPLES 4

/* we'll play our samples back at 11,000hz */
#define SAMPLE_RATE 11000

#define NUM_CHANNELS 4
#define CHAN_1 0
#define CHAN_2 1
#define CHAN_3 2
#define CHAN_4 3

#define SND_BOOM  0
#define SND_CLINK 1
#define SND_BASH  2
#define SND_HARP  3


/* I snatched vga_getkey() from svgalib sources     */
/* It lets you check for a keypress without waiting */
/* If you want to, you can link this file with      */
/* svgalib, delete vga_getkey() from this file      */
int vga_getkey();


/* soundIt demo */
void main()
   {
   Sample	snd[NUM_SAMPLES];
   char	ch;
      
   /* First, we load our raw samples into memory */
   Snd_loadRawSample( "boom.snd", &snd[0] );
   Snd_loadRawSample( "clink.raw", &snd[1] );
   Snd_loadRawSample( "glassbreak.snd", &snd[2] );
   Snd_loadRawSample( "harp.snd", &snd[3] );
  
   
   /* now init the soundIt library */
   if (Snd_init( NUM_SAMPLES, snd, SAMPLE_RATE, NUM_CHANNELS, "/dev/dsp" )==EXIT_FAILURE)
   	{
   	printf("Can't init soundIt library. yech..\n");
   	exit(0);
   	}

   /* now we can make some noise ! */
   printf("\nsoundIt "SOUNDIT_VERS" library demo1..playback at 11,000hz\n");
   printf("Hit 1, 2, 3 or 4 to make a sound in channel 1, 2, 3 or 4\n");
   printf("Hit 'q' to quit.\n");
   printf("Notice that only 1 sound plays at a time in each channel\n");
   printf("but all four channels can be heard simultaneously\n\n");
   
   ch = 0;
   
   while (ch!='q' && ch!='Q')
   	{
   	ch = vga_getkey();
   	
   	switch (ch)
   		{
   		case '1' : Snd_effect( SND_BOOM, CHAN_1 );
   			   break;
   			   
   		case '2' : Snd_effect( SND_CLINK, CHAN_2 );
   			   break;
   			   
   		case '3' : Snd_effect( SND_BASH, CHAN_3 );
   			   break;
   			   
   		case '4' : Snd_effect( SND_HARP, CHAN_4 );
   			   break;
   		}	   
   	}

   /* this needed, as the sound library forks() a process to do the mixing */   	
   /* and Snd_restore() will terminate the fork()'ed process */
   printf("\n");
   Snd_restore();
   }



/* The following vga_getkey() function is from..... */


/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright 1993 Harm Hanemaayer */
/* partially copyrighted (C) 1993 by Hartmut Schirmer */

int vga_getkey() {
	struct termio zap, original;
	char c;
	int e;

	ioctl(fileno(stdin), TCGETA, &original);	/* Get termio */
	zap = original;
	zap.c_cc[VMIN] = 0;				/* Modify termio  */
	zap.c_cc[VTIME] = 0;
	zap.c_lflag = 0;
	ioctl(fileno(stdin), TCSETA, &zap);		/* Set new termio */
	e = read(fileno(stdin), &c, 1);			/* Read one char */
	ioctl(fileno(stdin), TCSETA, &original);	/* Restore termio */
	if (e != 1)
		return 0;				/* No key pressed. */
	return c;					/* Return key. */
}
