/* Copyright 1994 Brad Pitzel

   Feel free to use/distribute/modify as long as proper credits
   are included.
*/

/*
  This little program shows how to use the SoundIt libraruy
*/

#include <stdlib.h>
#include <stdio.h>

/* these 3 are for the vga_getkey() */
#include <termios.h>
#include <unistd.h>
#include <sys/ioctl.h>

#include "soundIt.h"

#define NUM_SAMPLES 10

/* we'll play our samples back at 22,000hz */
#define SAMPLE_RATE 22000


#define NUM_CHANNELS 6

/* just for verbosity :-) */
#define CHAN_1 0
#define CHAN_2 1
#define CHAN_3 2
#define CHAN_4 3
#define CHAN_5 4
#define CHAN_6 5

#define SND_KICK  0
#define SND_SNARE1 1
#define SND_SNARE2  2
#define SND_HIHAT  3
#define SND_READY  4
#define SND_CYMB   5
#define SND_CYMCRSH 6
#define SND_BASS    7
#define SND_E_CHRD  8
#define SND_D_CHRD  9

/* I snatched vga_getkey() from svgalib sources     */
/* It lets you check for a keypress without waiting */
/* If you want to, you can link this file with      */
/* svgalib, then delete vga_getkey() from this file */
int vga_getkey();


/* soundIt demo */
void main()
   {
   int i;
   Sample	snd[NUM_SAMPLES];
   char	ch;
      
   /* First, we load our raw samples into memory */
   Snd_loadRawSample( "kick1.raw", &snd[SND_KICK] );
   Snd_loadRawSample( "english.raw", &snd[SND_SNARE1] );
   Snd_loadRawSample( "snare2.raw", &snd[SND_SNARE2] );
   Snd_loadRawSample( "swedish.raw", &snd[SND_HIHAT] );
   Snd_loadRawSample( "ready.raw", &snd[SND_READY] );
   Snd_loadRawSample( "cymbell.raw", &snd[SND_CYMB] );
   Snd_loadRawSample( "cymcrsh1.raw", &snd[SND_CYMCRSH] );
   Snd_loadRawSample( "bass.raw", &snd[SND_BASS] );
   Snd_loadRawSample( "e-chord.raw", &snd[SND_E_CHRD] );
   Snd_loadRawSample( "d-chord.raw", &snd[SND_D_CHRD] );
  
   
   /* now init the soundIt library */
   if (Snd_init( NUM_SAMPLES, snd, SAMPLE_RATE, NUM_CHANNELS, "/dev/dsp" )==EXIT_FAILURE)
   	{
   	printf("Can't init soundIt library. yech..\n");
   	exit(0);
   	}

   /* we can free up our mem, cause the driver's got its own copy */
   /* from the 'fork()' */
   for(i=0; i<NUM_SAMPLES; i++) free(snd[i].data);

   /* now we can make some noise ! */
   printf("\nsoundIt "SOUNDIT_VERS" library demo2.. playback at 22,000hz\n");
   printf("\n");
   printf("Hit 1, 2, 3, ... , 7, 8 to play the samples\n");
   printf("Hit 'q' to quit.\n");
   
   ch = 0;
   
   while (ch!='q' && ch!='Q')
   	{
   	ch = vga_getkey();
   	
   	switch (ch)
   		{
   		case '0' : usleep( 60000 );
   			   /* pause for timing */
   			   break;
   			   
   		case '1' : Snd_effect( SND_KICK, CHAN_1 );
   			   break;
   			   
   		case '2' : Snd_effect( SND_SNARE1, CHAN_3 );
   			   break;
   			   
   		case '3' : Snd_effect( SND_SNARE2, CHAN_2 );
   			   break;
   			   
   		case '4' : Snd_effect( SND_HIHAT, CHAN_3 );
   			   break;

   		case '5' : Snd_effect( SND_READY, CHAN_4 );
   			   break;

   		case '6' : Snd_effect( SND_CYMB, CHAN_5 );
   			   break;

   		case '7' : Snd_effect( SND_CYMCRSH, CHAN_5 );
   			   break;
   		case '8' : Snd_effect( SND_BASS, CHAN_6 );
   			   break;
   		case 'e' : Snd_effect( SND_E_CHRD, CHAN_4 );
   			   break;
   		case 'd' : Snd_effect( SND_D_CHRD, CHAN_4 );
   			   break;
   		}	   
   	}

   /* this needed, as the sound library forks() a process to do the mixing */   	
   /* and Snd_restore() will terminate the fork()'ed process */
   printf("\n");
   Snd_restore();
   }


/* The following vga_getkey() function is from..... */


/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright 1993 Harm Hanemaayer */
/* partially copyrighted (C) 1993 by Hartmut Schirmer */

int vga_getkey() {
	struct termio zap, original;
	char c;
	int e;

	ioctl(fileno(stdin), TCGETA, &original);	/* Get termio */
	zap = original;
	zap.c_cc[VMIN] = 0;				/* Modify termio  */
	zap.c_cc[VTIME] = 0;
	zap.c_lflag = 0;
	ioctl(fileno(stdin), TCSETA, &zap);		/* Set new termio */
	e = read(fileno(stdin), &c, 1);			/* Read one char */
	ioctl(fileno(stdin), TCSETA, &original);	/* Restore termio */
	if (e != 1)
		return 0;				/* No key pressed. */
	return c;					/* Return key. */
}
