/*	header.h */
#include <sys/types.h>
#include <sys/stat.h>

#ifndef __MSDOS__
# include <pwd.h>
# ifdef BSD
#    include <sys/timeb.h>
#    include <sys/time.h>
#    include <sgtty.h>
# else
#    include <sys/times.h>
#    include <termio.h>
# endif
#endif /* __MSDOS__ */

#include <fcntl.h>
#include <ctype.h>
#ifdef __TURBOC__
# include <stdarg.h>
#else
# include <varargs.h>
#endif
#include <signal.h>
#include <stdio.h>
#include <strings.h>

#if DEBLVL > 0
# define DEB1(msg) if ( DEBLVL > 0 ) { deb_log(msg); };
#else
# define DEB1(msg) /* */
#endif

#ifndef TRUE
# define TRUE (1)
#endif
#ifndef FALSE
# define FALSE (0)
#endif

#define SCORENAME   "Uscore"
#define LOGFNAME    "Ulog"
#define HELPNAME    "Uhelp"
#define LEVELSNAME  "Umaps"
#define FORTSNAME   "Ufortune"

#define MAXLEVEL 16 /*	max # levels + 1 in the dungeon	*/
#define MAXVLEVEL 5 /*	max # of levels in the temple of the luran (volcano) */

#define NINVT     (26)         /* maximum parts in inventory */
#define ANYINVT   (-1)         /* matches anything in inventory except gold */ 

#define MAXX 67
#define MAXY 17

#define SCORESIZE 25 	/* this is the number of people on a scoreboard max */
#define MAXPLEVEL 100 	/* maximum player level allowed		*/

/* 56 monsters, 7 demon lords, 1 demon prince, 1 God of Hellfire*/
#define MAXMONST 57 	/* maximum # monsters in the dungeon	*/

                                /* 3 funny numbers below, watch it ! (ws, 10.08.93) */
#define SPNUM     39         	/* maximum number of spells in existance	*/
#define MAXSCROLL 28            /* maximum number of scrolls that are possible	*/
#define MAXPOTION 35 	        /* maximum number of potions that are possible	*/

#define TIMELIMIT 40000 /* the maximum number moves before the game is called */
#define TAXRATE   1/20 	/* the tax rate for the LRS */
#define MAXOBJ     93 	/* the maximum number of objects   n < MAXOBJ */

/*	this is the structure definition of the monster data	*/
struct monst
{
	char	*name;
	char	level;
	short	armorclass;
	char	damage;
	char	attack;
	char	defense;
	char	genocided;
	char 	intelligence; /* used to choose movement */
	short	gold;
	short	hitpoints;
	unsigned long experience;
};

/*	this is the structure definition for the items in the dnd store */
struct _itm
{
	short	price;
	char	**mem;
	char	obj;
	char	arg;
	char	qty;
};

/* this is the structure for maintaining & moving the spheres of annihilation */
struct sphere
{
	struct sphere *p;	/* pointer to next structure */
	char x,y,lev;		/* location of the sphere */
	char dir;		/* direction sphere is going in */
	char lifetime;		/* duration of the sphere */
};

/*	defines for the character attribute array	c[]	*/
#define STRENGTH 0	/* characters physical strength not due to objects */
#define INTELLIGENCE 1
#define WISDOM 2
#define CONSTITUTION 3
#define DEXTERITY 4
#define CHARISMA 5
#define HPMAX 6
#define HP 7
#define GOLD 8
#define EXPERIENCE 9
#define LEVEL 10
#define REGEN 11
#define WCLASS 12
#define AC 13
#define BANKACCOUNT 14
#define SPELLMAX 15
#define SPELLS 16
#define ENERGY 17
#define ECOUNTER 18
#define MOREDEFENSES 19
#define WEAR 20
#define PROTECTIONTIME 21
#define WIELD 22
#define AMULET 23		/* if have amulet of invisibility */
#define REGENCOUNTER 24
#define MOREDAM 25
#define DEXCOUNT 26
#define STRCOUNT 27
#define BLINDCOUNT 28		/* if blind */
#define CAVELEVEL 29
#define CONFUSE 30		/* if confused */
#define ALTPRO 31
#define HERO 32			/* if hero  */
#define CHARMCOUNT 33
#define INVISIBILITY 34		/* if invisible */
#define CANCELLATION 35		/* if cancel cast */
#define HASTESELF 36		/* if hasted */
#define EYEOFLARN 37		/* if have eye */
#define AGGRAVATE 38
#define GLOBE 39
#define TELEFLAG 40		/* if been teleported */
#define SLAYING 41		/* if have orb of dragon slaying */
#define NEGATESPIRIT 42		/* if negate spirit */
#define SCAREMONST 43		/* if scare cast */
#define AWARENESS 44		/* if awareness cast */
#define HOLDMONST 45
#define TIMESTOP 46
#define HASTEMONST 47
#define CUBEofUNDEAD 48		/* if have cube */
#define GIANTSTR 49		/* if giant strength */
#define FIRERESISTANCE 50
#define BESSMANN 51		/* flag for hammer */
#define NOTHEFT 52
#define HARDGAME 53
#define BYTESIN 54		/* used for checkpointing in tok.c */

		/* 55 to 59 are open */



#define LANCEDEATH 60		/* if have LoD */
#define SPIRITPRO 61
#define UNDEADPRO 62
#define SHIELD 63
#define STEALTH 64
#define ITCHING 65
#define LAUGHING 66		/* not implemented */
#define DRAINSTRENGTH 67
#define CLUMSINESS 68
#define INFEEBLEMENT 69
#define HALFDAM 70
#define SEEINVISIBLE 71
#define FILLROOM 72
	/* 73 is open */
#define SPHCAST 74	/* nz if an active sphere of annihilation */
#define WTW 75		/* walk through walls */
#define STREXTRA 76	/* character strength due to objects or enchantments */
#define TMP 77		/* misc scratch space */
#define LIFEPROT 78 	/* life protection counter */

			/* FLAGS : non-zero if object has been made */
#define ORB 79		/* orb - 1 if created, 2 if held */
#define ELVUP 80	/* elevator up */
#define ELVDOWN 81	/* elevator down */
#define HAND 82		/* Hand of Fear */
#define CUBEUNDEAD 83	/* cube of undead control */
#define DRAGSLAY 84	/* orb of dragon slaying */
#define NEGATE 85	/* scarab of negate spirit */
#define URN 86		/* golden urn */
#define LAMP 87		/* brass lamp */
#define TALISMAN 88	/* Talisman of the Sphere */
#define WAND 89		/* wand of wonder */
#define STAFF 90	/* staff of power */
#define DEVICE 91	/* anti-theft */
#define SLASH 92 	/* sword of slashing */
#define ELVEN 93	/* elven chain */
#define VORP  94	/* Vorpal */
#define SLAY  95	/* Slayer */
#define PAD   96	/* Dealer McDopes */

#define COKED 97	/* timer for being coked out */
/* used up to 97 of 100 */


/*	defines for the objects in the game		*/

#define NO_OBJ  (0)
#define OALTAR 1
#define OTHRONE 2
#define OORB 3		/* orb of enlightement - gives expanded awareness
			  	as long as held */
#define OPIT 4
#define OSTAIRSUP 5
#define OELEVATORUP 6
#define OFOUNTAIN 7
#define OSTATUE 8
#define OTELEPORTER 9
#define OSCHOOL 10
#define OMIRROR 11
#define ODNDSTORE 12
#define OSTAIRSDOWN 13
#define OELEVATORDOWN 14
#define OBANK2 15
#define OBANK 16
#define ODEADFOUNTAIN 17
#define OMAXGOLD 70
#define OGOLDPILE 18
#define OOPENDOOR 19
#define OCLOSEDDOOR 20
#define OWALL 21
#define OTRAPARROW 66
#define OTRAPARROWIV 67

#define OLARNEYE 22

#define OPLATE 23
#define OCHAIN 24
#define OLEATHER 25
#define ORING 60
#define OSTUDLEATHER 61
#define OSPLINT 62
#define OPLATEARMOR 63
#define OSSPLATE 64
#define OSHIELD 68

#define OSWORDofSLASHING 26	/* impervious to rust, light, strong */
#define OHAMMER 27		/* Bessman's Flailing Hammer */
#define OSWORD 28
#define O2SWORD 29		/* 2 handed sword */
#define OSPEAR 30
#define ODAGGER 31
#define OBATTLEAXE 57
#define OLONGSWORD 58
#define OFLAIL 59
#define OLANCE 65

#define ORINGOFEXTRA 32
#define OREGENRING 33
#define OPROTRING 34
#define OENERGYRING 35
#define ODEXRING 36
#define OSTRRING 37
#define OCLEVERRING 38
#define ODAMRING 39

#define OBELT 40

#define OSCROLL 41
#define OPOTION 42
#define OBOOK 43
#define OCHEST 44

#define OAMULET 45
#define OORBOFDRAGON 46
#define OSPIRITSCARAB 47
#define OCUBEofUNDEAD 48
#define ONOTHEFT 49

#define ODIAMOND 50
#define ORUBY 51
#define OEMERALD 52
#define OSAPPHIRE 53

#define OENTRANCE 54
#define OVOLDOWN 55
#define OVOLUP 56
#define OHOME 69

#define OKGOLD 71
#define ODGOLD 72
#define OIVDARTRAP 73
#define ODARTRAP 74
#define OTRAPDOOR 75
#define OIVTRAPDOOR 76
#define OTRADEPOST 77
#define OIVTELETRAP 78
#define ODEADTHRONE 79
#define OANNIHILATION 80		/* sphere of annihilation */
#define OTHRONE2 81
#define OLRS 82				/* Larn Revenue Service */
#define OCOOKIE 83
#define OURN 84			/* golden urn - not implemented */
#define OBRASSLAMP 85	/* brass lamp - genie pops up and offers spell */
#define OHANDofFEAR 86		/* hand of fear - scare monster spell lasts
				   twice as long if have this */
#define OSPHTALISMAN 87		/* talisman of the sphere */
#define OWWAND 88	/* wand of wonder - cant fall in trap doors/pits */
#define OPSTAFF 89		/* staff of power - cancels drain life attack*/

#define OVORPAL 90	/* ? - not implemented */
#define OSLAYER 91	/* magical sword - increases intelligence by 10,
			   halves damage caused by demons, demon prince 
			   and lucifer - strong as lance of death against them*/

#define OELVENCHAIN 92		/* elven chain - strong and light, 
				   impervious to rust */
#define OSPEED 93		
#define OACID 94
#define OHASH 95
#define OSHROOMS 96
#define OCOKE 97
#define OPAD 98		/* Dealer McDope's Pad */
/* used up to 98 */

/*	defines for the monsters as objects		*/

#define LEMMING 1 
#define GNOME 2
#define HOBGOBLIN 3
#define JACKAL 4 
#define KOBOLD 5 
#define ORC 6 
#define SNAKE 7
#define CENTIPEDE 8
#define JACULI 9 
#define TROGLODYTE 10 
#define ANT 11 
#define EYE 12 
#define LEPRECHAUN 13
#define NYMPH 14 
#define QUASIT 15 
#define RUSTMONSTER 16 
#define ZOMBIE 17 
#define ASSASSINBUG 18 
#define BUGBEAR 19 
#define HELLHOUND 20 
#define ICELIZARD 21 
#define CENTAUR 22 
#define TROLL 23 
#define YETI 24 
#define WHITEDRAGON 25 
#define ELF 26 
#define CUBE 27 
#define METAMORPH 28 
#define VORTEX 29 
#define ZILLER 30 
#define VIOLETFUNGI 31 
#define WRAITH 32 
#define FORVALAKA 33 
#define LAMANOBE 34 
#define OSEQUIP 35 
#define ROTHE 36 
#define XORN 37 
#define VAMPIRE 38 
#define INVISIBLESTALKER 39 
#define POLTERGEIST 40 
#define DISENCHANTRESS 41 
#define SHAMBLINGMOUND 42 
#define YELLOWMOLD 43
#define UMBERHULK 44
#define GNOMEKING 45
#define MIMIC 46
#define WATERLORD 47
#define BRONZEDRAGON 48
#define GREENDRAGON 49
#define PURPLEWORM 50
#define XVART 51
#define SPIRITNAGA 52
#define SILVERDRAGON 53
#define PLATINUMDRAGON 54
#define GREENURCHIN 55
#define REDDRAGON 56
#define DEMONLORD 57
#define DEMONPRINCE 64
#define LUCIFER 65

                             /* SPELLS: */
#define S_NON (-1)  /* None */
#define S_PRO  (0)
#define S_MLE  (1)
#define S_DEX  (2)
#define S_SLE  (3)
#define S_CHM  (4)
#define S_SSP  (5)
#define S_WEB  (6)
#define S_STR  (7)
#define S_ENL  (8)
#define S_HEL  (9)
#define S_CBL (10)
#define S_CRE (11)
#define S_PHA (12)
#define S_INV (13)
#define S_BAL (14)
#define S_CLD (15)
#define S_PLY (16)
#define S_CAN (17)
#define S_HAS (18)
#define S_CKL (19)
#define S_VPR (20)
#define S_DRY (21)
#define S_LIT (22)
#define S_DRL (23)
#define S_GLO (24)
#define S_FLO (25)
#define S_FGR (26)
#define S_SCA (27)
#define S_HLD (28)
#define S_STP (29)
#define S_TEL (30)
#define S_MFI (31)
#define S_MKW (32)
#define S_SPH (33)
#define S_GEN (34)
#define S_SUM (35)
#define S_WTW (36)
#define S_ALT (37)
#define S_PER (38)

                             /* SCrOLLS: */
#define R_ENC_A  (0)
#define R_ENC_W  (1)
#define R_ENL    (2)
#define R_BLANK  (3)
#define R_C_MON  (4)
#define R_C_ART  (5)
#define R_AGG_M  (6)
#define R_TIM_W  (7)
#define R_TELEP  (8)
#define R_XPD_A  (9)
#define R_HAS_M (10)
#define R_M_HEL (11)
#define R_SPIRT (12)
#define R_UNDED (13)
#define R_STEAL (14)
#define R_MAPPG (15)
#define R_HLD_M (16)
#define R_GEM_P (17)
#define R_SPL_X (18)
#define R_IDENT (19)
#define R_REM_C (20)
#define R_ANNIH (21)
#define R_PULVR (22)
#define R_LIFEP (23)

                             /* POTIONS: */
#define P_SLEEP  (0)
#define P_HEALG  (1)
#define P_R_LVL  (2)
#define P_INC_A  (3)
#define P_WISDM  (4)
#define P_STRNG  (5)
#define P_R_CHA  (6)
#define P_DIZZY  (7)
#define P_LEARN  (8)
#define P_GLD_D  (9)
#define P_MNS_D (10)
#define P_FORGT (11)
#define P_WATER (12)
#define P_BLIND (13)
#define P_CONFN (14)
#define P_HEROS (15)
#define P_STURD (16)
#define P_GIANT (17)
#define P_FIRE_ (18)
#define P_TRS_F (19)
#define P_INSTH (20)
#define P_CURED (21)
#define P_POISN (22)
#define P_SEE_I (23)


#define BUFBIG	4096			/* size of the output buffer */
#define MAXIBUF	4096			/* size of the input buffer */
#define LOGNAMESIZE 40			/* max size of the players name */
#define PSNAMESIZE 40			/* max size of the process name */
#define SAVEFILENAMESIZE 128		/* max size of the savefile path */

extern char aborted[],beenhere[],boldon,cheat,ckpfile[],ckpflag;
extern char *class[],course[],diagfile[],drug[],fortfile[],helpfile[];
extern char *inbuffer, is_male;
extern char item[MAXX][MAXY],iven[],know[MAXX][MAXY],larnlevels[],lastmonst[];
extern char level,*levelname[],logfile[],loginname[],logname[],*lpbuf,*lpend;
extern char *lpnt,moved[MAXX][MAXY],mitem[MAXX][MAXY],monstlevel[];
extern char monstnamelist[],nch[],ndgg[],nlpts[],nomove,nosignal,nowelcome;
extern char nplt[],nsw[],*objectname[], char_class[];
extern char objnamelist[],optsfile[],*potionname[],potprob[];
extern char predostuff,restorflag,savefilename[],scorefile[],scprob[];
extern char screen[MAXX][MAXY],*scrollname[],*spelcode[],*speldescript[];
extern char spelknow[],*spelname[],*spelmes[],spelweird[MAXMONST+8][SPNUM];
extern char splev[],stealth[MAXX][MAXY],wizard;
extern short diroffx[],diroffy[],hitflag,hit2flag,hit3flag,hitp[MAXX][MAXY];
extern short iarg[MAXX][MAXY],ivenarg[],lasthx,lasthy,lastnum,lastpx,lastpy;
extern short nobeep,oldx,oldy,playerx,playery;
extern int dayplay,enable_scroll,srcount,stayflag,yrepcount,userid,lfd,fd;
extern long initialtime, skill[],gtime,c[],cbak[];
extern unsigned long randx;
extern struct monst monster[];
extern struct sphere *spheres;
extern struct _itm itm[];

char *fortune(),*malloc(),*getenv(),*getlogin(),*lgetw(),*lgetl(),*ctime();
char *tmcapcnv(),*tgetstr(),*tgoto();
long lgetc(),lrint(),time();
long readnum();
long gettax();

	/* macro to create scroll #'s with probability of occurrence */
#define newscroll() (scprob[rund(81)])
	/* macro to return a potion # created with probability of occurrence */
#define newpotion() (potprob[rund(41)])
	/* macro to return the + points on created leather armor */
#define newleather() (nlpts[rund(c[HARDGAME]?10:13)])
	/* macro to return the + points on chain armor */
#define newchain() (nch[rund(10)])
	/* macro to return + points on plate armor */
#define newplate() (nplt[rund(c[HARDGAME]?3:10)])
	/* macro to return + points on new daggers */
#define newdagger() (ndgg[rund(13)])
	/* macro to return + points on new swords */
#define newsword() (nsw[rund(c[HARDGAME]?6:13)])
	/* macro to destroy object at present location */
#define forget() (item[playerx][playery]=know[playerx][playery]=0)
	/* macro to wipe out a monster at a location */
#define disappear(x,y) (mitem[x][y]=know[x][y]=0)

	/* defines below are for use in the termcap mode only */
#define ST_START 1
#define ST_END   2
#define BOLD     3
#define END_BOLD 4
#define CLEAR    5
#define CL_LINE  6
#define CL_DOWN 14
#define CURSOR  15
	/* macro to turn on bold display for the terminal */
#define setbold() (*lpnt++ = ST_START)
	/* macro to turn off bold display for the terminal */
#define resetbold() (*lpnt++ = ST_END)
	/* macro to setup the scrolling region for the terminal */
#define setscroll() enable_scroll=1 
	/* macro to clear the scrolling region for the terminal */
#define resetscroll() enable_scroll=0
	/* macro to clear the screen and home the cursor */
#define clear() (*lpnt++ =CLEAR, cbak[SPELLS]= -50, srcount= 0)
	/* macro to clear to end of line */
#define cltoeoln() (*lpnt++ = CL_LINE)

	/* macro to output one byte to the output buffer */
#define lprc(ch) ((lpnt>=lpend)?(*lpnt++ =(ch), lflush()):(*lpnt++ =(ch)))

	/* macro to seed the random number generator */
#define srand(x) (randx=x)
	/* macros to generate random numbers   1<=rnd(N)<=N   0<=rund(N)<=N-1 */
#define rnd(x)  ((int)((((randx=randx*1103515245+12345)>>7)%(x))+1))
#define rund(x) ((int)((((randx=randx*1103515245+12345)>>7)%(x))))
#define rndl(x)  ((((randx=randx*1103515245+12345)>>7)%(x))+1)
#define rundl(x) ((((randx=randx*1103515245+12345)>>7)%(x)))
	/* macros for miscellaneous data conversion */
#define min(x,y) (((x)>(y))?(y):(x))
#define max(x,y) (((x)>(y))?(x):(y))

        /* the number of elements of a one-dimensional array */
#define N_ELEM(array) (sizeof(array) / sizeof((array)[0]))
