// DeHackEd version 2.3
// Written by Greg Lewis, gregl@umich.edu
// If you release any versions of this code, please include
// the author in the credits.  Give credit where credit is due!

// Include the Linux compatibility header (Sam Lantinga 3/16/95)
#include "linux.h"
#include "constance.h"

// Find out what byte order we have
#ifdef linux
#include <endian.h>
#else
#include <sys/endian.h>
#endif

#define NEED_SEX	(BYTE_ORDER != LITTLE_ENDIAN)
#define bytesex(x)	(x = \
	((x << 24) | ((x & 0xff00) << 8) | ((x >> 8) & 0xff00) | (x >> 24)))
#define bytesec(x)	(x = (x << 8) | (x >> 8))
/*
#define bytesec(x)	{ unsigned short temp=x; \
			  temp = (temp << 8) | (temp >> 8); \
			  x = temp; \
			}
*/

// Sizes for the different versions
// Note: SGI X11 Doom is not yet supported!
#define SIZE1_12  580391L
#define SIZE1_16  687001L
#define SIZE2_16  686921L
#define SIZE2_17  686993L
#define SIZE2_17A 686997L
#define SIZE2_18  709865L
#define SIZE2_19  709905L
#define SIZEX_18  304132L
#define SIZES_18  300036L
#define SIZE_SGI16  492480L
#define SIZE_SGI18  518064L

// Version numbers
typedef enum {DOOM1_2,  DOOM1_6,  DOOM2_0, DOOM1_9, LNX_X18, LNX_S18, SGI_X18} EVersions;
typedef enum {DOOM1_12, DOOM1_16, DOOM2_16, DOOM2_17, DOOM2_17A,
						DOOM2_18, DOOM2_19, DOOMX_18, DOOMS_18, DOOM_SGI, USERDEF} ETruever;

// Editing modes
typedef enum {THING_EDIT, FRAME_EDIT, AMMO_EDIT, SOUND_EDIT, SPRITE_EDIT,
				  TEXT_EDIT, THING_LIST} EModes;

// My own defines
typedef enum {NO, YES} EBool;

#ifdef HAVE_MOUSE
// Mouse buttons
typedef enum {buttonDown, buttonUp} EButton;
#endif

// Window color defines
#define INFO     0x3F	// Bright white on cyan
#define INFGRAY  0x37	// White on cyan
#define INFDGRAY 0x38	// Grey on cyan
#define ERROR    0x4F	// Bright white on red
#define INPUT    0x2F	// Bright white on green
#define INPDGRAY 0x28	// Grey on green
#define INPHILIT 0x3E	// Purple on green
#define NORMAL   0x1F	// Bright white on blue
#define NERROR   0x1C	// Red on blue
#define NGRAY    0x17	// White on blue
#define NHILIT   0x71	// Blue on white
#define BARS     0x1F	// Bright white on blue

// Redraw defines
typedef enum {NOT, DATA, ALLDATA, ALL} ERedraw;

#ifdef HAVE_MOUSE
// Mouse defines
#define LEFTBUTTON               1   /* bit 0 */
#define RIGHTBUTTON              2   /* bit 1 */
#define MIDDLEBUTTON             4   /* bit 2 */
#define CURSOR_LOCATION_CHANGED  1   /* event mask bits */
#define LEFT_BUTTON_PRESSED      2
#define LEFT_BUTTON_RELEASED     4
#define RIGHT_BUTTON_PRESSED     8
#define RIGHT_BUTTON_RELEASED    16
#define MIDDLE_BUTTON_PRESSED    32
#define MIDDLE_BUTTON_RELEASED   64
#endif /* HAVE_MOUSE */

// "global" array constants
#define CUR    0
#define FIELD  1
#define TOPROW 2
#define GMIN    3
#define GMAX    4

// String input constants
typedef enum {STRING, LONGINT, YESNO} EInptype;

// limits on long integers
#ifndef LONG_MAX
#define LONG_MAX            0x7FFFFFFFL
#endif
#ifndef LONG_MIN
#define LONG_MIN            ((long)0x80000000L)
#endif

// Format for directory entries in the doom.wad file
typedef struct ResourceT
{
	unsigned long resstart;
	unsigned long reslength;
	char resname[9];
} ResourceS;

