
#ifndef TTY_Graphics_h
#define TTY_Graphics_h

// This module provides an interface to tty/vga graphics for a variety
// of real interfaces

#include "keyboard.h"

// Defines for setcursor()
#define _NOCURSOR	0
#define _NORMALCURSOR	1

// Defines for set_colors()
#define FOREGROUND	30
#define BACKGROUND	40
#define BRIGHT		1
#define DIM		2
#define BLACK		0
#define RED		1
#define GREEN		2
#define YELLOW		3
#define BLUE		4
#define MAGENTA		5
#define CYAN		6
#define WHITE		7

// Defines for set_grmode()
#define TEXT25		0
#define TEXT50		1
#define GRAPHICS	2
#define LASTMODE	3

// Defines for set_palette()
struct color {
	unsigned char red;
	unsigned char green;
	unsigned char blue;
	};

// The TTY graphics module:

class TTY_Graphics {

public:
	TTY_Graphics();
	virtual ~TTY_Graphics();

	virtual int ibm_charset(void);
	virtual void flush(void);
	virtual void setcursor(int on);
	virtual void set_default_colors(void);
	virtual void set_colors(int bright, int fg, int bg);
	virtual void clear(void);
	virtual void clrbox(int x, int y, int width, int height);
	virtual void clreol(void);
	virtual void gotoxy(int x, int y);
	virtual void putch(int ch);

	// Actual graphics routines.  Not available in a TTY.
	virtual int has_graphics(void);
	virtual void set_grmode(int newmode);
	virtual int get_grmode(void);
	virtual void set_colormap(struct color colormap[256]);
	virtual void clr_grscreen(void);
	virtual void put_graphics_txt(int x, int y, char *string, 
							unsigned char color);
	virtual void drawpoint(int x, int y, unsigned char color);

	TTY_Keyboard *keyboard;

protected:
	int mode;
	int lastmode;
};

// Include other interfaces here...
#include "vga_graphics.h"
#include "x11_graphics.h"

#endif
