#include <stdio.h>

main(int argc, char *argv[])
{
	int i, j, little_endian=0;
	unsigned char image[16], bit, byte;

	if ( argv[1] && (strcmp(argv[1], "-little-endian") == 0) )
		little_endian=1;

	printf("static char pc8x8_fontdata[256][8] = {\n");
	while ( fread(image, 16, 1, stdin) ) {
		printf("\t{ ");
		for ( i=0; i<8; ++i ) {
			if ( i )
				printf(", ");
			if ( little_endian ) {
				for ( j=0, byte='\0'; j<8; ++j ) {
					bit = (image[i]&0x80);
					image[i] <<= 1;
					byte |= (bit>>(7-j));
				}
			} else {
				byte = image[i];
			}
			printf("0x%.2x", byte);
		}
		printf(" },\n");
	}
	printf("};\n");
}
