/*
    Cherrybomb.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Cherrybomb

- init
{
  [super init];
  [self describe: "cherry": "a cherry": "the cherry":
  "This is actually a magic weapon that can be used only once."];
  //  Damage is exaggerated because instead of being between zero and 30
  //  it's 30 every time.
  [self setspeeddamage: 2: 60];
  return self;
}

- kill: who: dobj
{
  if ([dobj isdead])
    return self;

  //  We have to prevent people from getting in extra hits by typing kill
  //  over and over.  We only really want to hit if this function was called
  //  by the heartbeat.  The heartbeat is nice enough to set a flag for us,
  //  since otherwise it would be hard to tell.

  if ([who checkkillflag]) {
    id owner_location;
    if (dobj == who) {
      [who clue: who];
      return self;
    }
    if (++beatcount == speed) {
      owner_location = [who getlocation];
      [owner_location emote: who: "throw the cherry at":
      "throws the cherry at": dobj: ""];
      [owner_location echo: "The cherry EXPLODES!"];
      [dobj hit: who: 30.0];
      [owner_location theres_a_fight_going_on];
      [self logout];
    }
  } else {
    if (dobj == who) {
      [who echo: "If you want to delete your account, e-mail the mud admin!"];
      [who clue: who];
      return self;
    }
    [[who enemies] addElementIfAbsent: dobj];
  }

  return self;
}

@end
