/*
    Container.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Container

- init
{
  [super init];
  contents = [Bag new];
  capacity = 5;
  return self;
}

- empty: who
{
  char temp[80];
  sprintf (temp, "%s contains nothing.", capitalize ([self def]));
  [who echo: temp];
  return self;
}

- nonempty: who
{
  char temp[80];
  sprintf (temp, "%s contains:", capitalize ([self def]));
  [who echo: temp];
  return self;
}

- free
{
  //  Any contents not removed are lost.
  [contents safeMakeObjectsPerform: @selector(logout)];
  [contents free];
  return [super free];
}

- add: something
{
  [contents addElement: something];
  return self;
}

- remove: something
{
  [contents removeElement: something];
  return self;
}

- (int) capacity
{
  return capacity;
}

- listcontents: who
{
  void blah (id whatever)
  {
    [who echo: capitalize ([whatever indef])];
  }
  if ([contents isEmpty])
    [self empty: who];
  else {
    [self nonempty: who];
    [contents withObjectsCall: blah];
  }
  return self;
}

- contents
{
  return contents;
}

- find: (char *) what: (int) number
{
  return generic_find (contents, what, number);
}

@end
