/*
    King.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation King

+ new: (char *) whose_office
{
  return [[self alloc] init: whose_office];
}

- init: (char *) whose_office
{
  [super init];
  [self setmudname: "king"];
  [self setlongdesc: "This is one of the four kings of the Tarot Empire."];
  if (!strcmp (whose_office, "ofkcup")) {
    [self setdef: "the King of Cups"];
    [self setindef: "the King of Cups"];
    [[Sword new] setlocation: self];
    [[Chalice new] setlocation: self];
  } else if (!strcmp (whose_office, "ofkwand")) {
    [self setdef: "the King of Wands"];
    [self setindef: "the King of Wands"];
    [[Heavyarmor new] setlocation: self];
    [[Cherrybomb new] setlocation: self];
    [[Staff new] setlocation: self];
  } else if (!strcmp (whose_office, "ofksword")) {
    [self setdef: "the King of Swords"];
    [self setindef: "the King of Swords"];
    [[Heavyarmor new] setlocation: self];
    [[Goodsword new] setlocation: self];
  } else /* ofkcoin */ {
    [self setdef: "the King of Coins"];
    [self setindef: "the King of Coins"];
    [[Sword new] setlocation: self];
    [[[Shield new] describe: "shield": "fancy shield":
    "the fancy shield":
"This sturdy metal shield has been decorated with various different metals\n\
to show a picture of a very ornate crown."] setlocation: self];
  }
  stamina = maxstamina = 45.0;
  strcpy (deadname, "king");
  strcpy (deaddef, "the dead king");
  strcpy (deadindef, "a dead king");
  strcpy (deaddesc, "The king is dead.  Long live the king!");
  return self;
}

- (int) level
{
  return 3;
}

@end
