/*
    Mudadmin.h  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _MUDADMIN_H
#define _MUDADMIN_H

//  Class for mud administrator object.

#include "Player.h"

@interface Mudadmin: Player
{
  int monitor_heartbeat, ignore_attacks;
}

//  MUD ADMIN ACTIONS (GLOBAL SCOPE, CAN'T BE OVERRIDDEN)

- summon: dobj;
- goto: dobj;
- see: dobj;
- listworld;
- halt;
- savehalt;
- heart;
- fetch: dobj;
// - clone: dobj;
- audit: dobj;

//  LOCAL MUD ADMIN ACTIONS (CAN'T BE OVERRIDDEN)

- stash: dobj;
- free: dobj;

//  ACTIONS

- examine: who: dobj;

//  METHODS

- init;
- help;
- hit: fromwho: (float) damage;

- (int) level;
- (float) maxstamina;

//  Receive command from terminal.
- (int) ohce: (char *) text;

- create: (char *) name: (char *) newindef: (char *) newdef: (char *) newdesc;

- (void) heartbeat;

//  Do a special mud administrator action.
- (int) doadmin: (char *) someaction;
- (int) check_admin_action: (char *) action: (int) numargs;

@end
#endif
