/*
    Mudobject.h  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _MUDOBJECT_H
#define _MUDOBJECT_H

//  Class for generic mud object.  Provides default actions and methods.

#include <objc/Object.h>

@interface Mudobject: Object
{
  //  Descriptions
  char *mudname;
  char *indef;
  char *def;
  char *longdesc;

  //  Beatcount -- used to count heartbeats for slower actions
  //  dead      -- true if object is ready for deletion
  //  loggedout -- true if object has already received logout message
  //  audit     -- mud admin audit flag
  int beatcount, dead, loggedout, audit;
}

//  ACTIONS


//  METHODS

- init;
- free;
- logout;
- toggle_audit;

//  Return priority of an action method.
- (float) priority: (char *) action: (int) numargs;

//  Methods to change the name and descriptions.
- describe: (char *) newname: (char *) newindef: (char *) newdef:
  (char *) newlongdesc;
- setmudname: (char *) newname;
- setindef: (char *) newdesc;
- setdef: (char *) newdesc;
- setlongdesc: (char *) newdesc;

//  Methods to get the name and descriptions.
- (char *) mudname;
- (char *) indef;
- (char *) def;
- (char *) longdesc;

//  Display text on terminal.
- echo: (char *) text;
- emote: emoter: (char *) verb_you: (char *) verb_he: (char *) emotion;
- emote: emoter: (char *) verb_you: (char *) verb_he: dobj: (char *) emotion;
- say: emoter: (char *) verb_you: (char *) verb_he: (char *) emotion;

//  Called 4 times a second.
- (void) heartbeat;

//  List contents, if applicable.
- listcontents: who;

//  Remove the specified object from the enemies list, if applicable.
//  This message is sent to every object in the mud when something dies,
//  so every object must be able to receive it.
- clue: dontkillme;

//  Returns value of dead.
- (int) isdead;

@end
#endif
