/*
    Room.h  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _ROOM_H
#define _ROOM_H

//  Class for room object.

#include "Mudobject.h"

@interface Room: Mudobject
{
  id contents, n, s, e, w, u, d;
}

//  ACTIONS

- n: who;
- s: who;
- e: who;
- w: who;
- u: who;
- d: who;

//  METHODS

- init;

//  Free is disallowed for rooms.  That way I don't have to worry about
//  what happens to all the stuff that's in the room when it goes away
//  and how to change the movement actions of adjoining rooms.
- free;

//  Return priority of an action method.
- (float) priority: (char *) action: (int) numargs;

//  A room echo is sent to everybody in the room.
- echo: (char *) text;
- emote: emoter: (char *) verb_you: (char *) verb_he: (char *) emotion;
- emote: emoter: (char *) verb_you: (char *) verb_he: dobj: (char *) emotion;
- say: emoter: (char *) verb_you: (char *) verb_he: (char *) emotion;

//  Standard container messages.
- listcontents: who;
- contents;
- add: somebody;
- remove: somebody;
- find: (char *) what: (int) number;
- (int) capacity;

//  Link up the map.
- setexit: (char *) direction: destination;
- dirquery: (char) dir;

//  Notification of brawl.
- theres_a_fight_going_on;

@end
#endif
