/*
    Sack.h  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

//  A sack is a container that a player can explicitly bag or unbag
//  things in.  Something that is merely a container cannot be used in
//  that way -- you cannot use a corpse like a sack.

#ifndef _SACK_H
#define _SACK_H

#include "Container.h"

@interface Sack: Container

- init;

//  ACTIONS

- bag: who: dobj;

//  The priority of the bag action varies according to how full the
//  Sack is, so that things will get distributed evenly.  :-)
- (float) priority: (char *) action: (int) numargs;

@end
#endif
