/*
    Spider.m  Class definition.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#include "cheezmud.h"

@implementation Spider

- init
{
  [super init];
  [self describe: "spider": "a spider": "the spider":
    "It is just a harmless little black spider."];
  return self;
}

- (void) heartbeat
{
  if (dead)
    return;
  if (++beatcount == 80) {
    beatcount = 0;
    if ([location isKindOf: [Player class]])
      [location emote: self: "bite": "bites": location: ""];
    else
      [location emote: self: "crawl": "crawls": " around"];
  }
}

- hit: fromwho: (float) damage
{
  if (dead)
    return self;
  dead = 1;
  [location emote: self: "die": "dies": ""];
  [[[Corpse new] describe: "spider": "a dead spider": "the dead spider":
    "It's a poor little dead spider that some nasty person killed."]
    setlocation: location];
  [self logout];
  return self;
}

@end
