/*
    net.h  Networking stuff for cheezmud.
    Copyright (C) 1995  David Flater.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _NET_H
#define _NET_H

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <stdlib.h>
#include <assert.h>
#include <sys/types.h>
#include <sys/time.h>
#include <sys/file.h>
#include <sys/stat.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <netinet/tcp.h>
#include <arpa/inet.h>
#include <arpa/telnet.h>
#include <netdb.h>
#include <errno.h>
#include <signal.h>
#include <unistd.h>
#include <fcntl.h>
#include <math.h>
#include "Player.h"

/* Delete these if they are redefs and cause problems */
#define max(a,b) (a < b ? b : a)
#define min(a,b) (a > b ? b : a)

/* Number of signals, should be set by signal.h but not always is */
#ifndef NSIG
#define NSIG 32
#endif

/* Some compilers actually don't define O_NONBLOCK.  O_NDELAY is the same
 * on some machines; on others, it wreaks havoc.  Pray that this has the
 * desired effect!
 */
#ifndef O_NONBLOCK
#define O_NONBLOCK O_NDELAY
#endif

/* Connection types:
 *     new              New inbound connection
 *     auth             New connection being authenticated
 *     player           Established connection
 *     delete           Connection being deleted
 */
typedef enum {new, auth, player, delete} contype;

struct conlist {
  struct conlist *next;        /* Linked list */

/* Mud object */

  Player *mudplayer;

/* Connection information */

  int con;                     /* fd for input and output */
  void (*handler) ();          /* Where to process received messages */
  void (*notify) ();           /* Notification of deletion */
  contype type;                /* Type of connection. */
  char *name;                  /* Name of player. */
  char hname[80];              /* Name of host */
  long lastrecv;               /* Timestamp of last receive */
  long maxidle;

/* Input-related stuff */

  char *inbuffer;              /* Generic input buffer */
  long inbuflen;               /* How long is it */
  long inmemsize;              /* Size of memory block >= inbuflen */

/* Output-related stuff */

  char *yettosend;             /* Generic output buffer */
  long sendlen;                /* How long is it */
  long sendmemsize;            /* Size of memory block >= sendlen */

};

extern void
unbreak_pipe ();
extern int
broke_pipe ();
extern void
sig_setup ();

#endif
