#include "config.h"
/* $Id: Makefile.cpp,v 1.7 1993/02/23 23:16:46 nils Exp $ */
#ifdef MK_TOPDIR
TOPDIR=..
#else
TOPDIR=../..
#endif

#define INCLUDEOPT -I${TOPDIR}/config -I${TOPDIR}/src/hdrs

CC= C_COMPILER
CFLAGS= C_OPTIONS INCLUDEOPT
CPP= C_PREPROCESS
LIBS= -L/usr/local/lib C_LIBS
#ifdef MAKE_DEPEND
MKDEP= MAKE_DEPEND
#endif

#ifdef MK_TOPDIR
/* we're in the top make directory. */

all: makefiles nomakefiles

nomakefiles: comm/all db/all io/all files/all muse/all util/all

comm/all: comm/Makefile
	(cd comm; ${MAKE})

db/all: db/Makefile
	(cd db; ${MAKE})

io/all: io/Makefile
	(cd io; ${MAKE})

files/all: files/Makefile
	(cd files; ${MAKE})

muse/all: muse/Makefile files/all io/all db/all comm/all
	(cd muse; ${MAKE})

util/all: util/Makefile
	(cd util; ${MAKE})

install: nomakefiles muse/install util/install

muse/install: nomakefiles
	(cd muse; ${MAKE} install)

util/install: nomakefiles
	(cd util; ${MAKE} install)

makefiles: Makefile files/Makefile io/Makefile util/Makefile comm/Makefile muse/Makefile db/Makefile

clean: makefiles
	for i in files io util comm muse db util; do (cd $$i; ${MAKE} clean); done

Makefile: Makefile.cpp ../config/config.h
	-rm -f Makefile
	if [ -f Makefile ] ; \
	then \
	  $(CPP) INCLUDEOPT -DMK_TOPDIR Makefile.cpp |cat -s >Makefile ; \
	  echo i just redid the makefile. try 'make'ing ; \
	else \
	  $(CPP) INCLUDEOPT -DMK_TOPDIR Makefile.cpp |cat -s >Makefile ; \
	  echo okay, i just created a makefile. ; \
	fi
	false

files/Makefile: Makefile.cpp ../config/config.h
	-rm -f files/Makefile
	$(CPP) INCLUDEOPT -DMK_FILES Makefile.cpp |cat -s >files/Makefile
	(cd files; ${MAKE} depend)

io/Makefile: Makefile.cpp ../config/config.h
	-rm -f io/Makefile
	$(CPP) INCLUDEOPT -DMK_IO Makefile.cpp |cat -s >io/Makefile
	(cd io; ${MAKE} depend)

util/Makefile: Makefile.cpp ../config/config.h
	-rm -f util/Makefile
	$(CPP) INCLUDEOPT -DMK_UTIL Makefile.cpp |cat -s >util/Makefile
	(cd util; ${MAKE} depend)

comm/Makefile: Makefile.cpp ../config/config.h
	-rm -f comm/Makefile
	$(CPP) INCLUDEOPT -DMK_COMM Makefile.cpp |cat -s >comm/Makefile
	(cd comm; ${MAKE} depend)

muse/Makefile: Makefile.cpp ../config/config.h
	-rm -f muse/Makefile
	$(CPP) INCLUDEOPT -DMK_MUSE Makefile.cpp |cat -s >muse/Makefile
	(cd muse; ${MAKE} depend)

db/Makefile: Makefile.cpp ../config/config.h
	-rm -f db/Makefile
	$(CPP) INCLUDEOPT -DMK_DB Makefile.cpp |cat -s >db/Makefile
	(cd db; ${MAKE} depend)

#endif

#ifdef MK_IO
# ifdef USER_RWHO
#  define C_FILES bsd.c clilib.c compress.c log.c newconc.c rwho.c
#  define O_FILES bsd.o clilib.o compress.o log.o newconc.o rwho.o
# else
#  define C_FILES bsd.c clilib.c compress.c log.c newconc.c
#  define O_FILES bsd.o clilib.o compress.o log.o newconc.o
# endif
# define OUT_ARCHIVE libio.a
#endif

#ifdef MK_COMM
# define C_FILES admin.c create.c dbtop.c help.c look.c pcmds.c player.c rob.c set.c speech.c prog.c com.c
# define O_FILES admin.o create.o dbtop.o help.o look.o pcmds.o player.o rob.o set.o speech.o prog.o com.o
# define OUT_ARCHIVE libcomm.a
#endif

#ifdef MK_MUSE
# define C_FILES cque.c fifo.c game.c match.c move.c nalloc.c players.c powerlist.c powers.c predicates.c stringutil.c timer.c unparse.c utils.c wild.c
# define O_FILES cque.o fifo.o game.o match.o move.o nalloc.o players.o powerlist.o powers.o predicates.o stringutil.o timer.o unparse.o utils.o wild.o
# define BINFILES netmuse
# define DID_ALL
thisdir: netmuse
	@echo >/dev/null

netmuse: O_FILES ../io/libio.a ../comm/libcomm.a ../files/libfiles.a ../db/libdb.a
	$(CC) $(CFLAGS) -o netmuse O_FILES ../io/libio.a ../comm/libcomm.a ../files/libfiles.a ../db/libdb.a C_LIBS MDEBUG_LIBS

#endif

#ifdef MK_FILES
# define C_FILES editor.c mail.c
# define O_FILES editor.o mail.o
# define OUT_ARCHIVE libfiles.a
#endif

#ifdef MK_DB
# ifdef USE_SPACE
#  define C_FILES boolexp.c db.c destroy.c eval.c inherit.c space.c
#  define O_FILES boolexp.o db.o destroy.o eval.o inherit.o space.o
# else
#  define C_FILES boolexp.c db.c destroy.c eval.c inherit.c
#  define O_FILES boolexp.o db.o destroy.o eval.o inherit.o
# endif
# define OUT_ARCHIVE libdb.a
#endif

#ifdef MK_UTIL
# define C_FILES /* decompress.c dump.c extract.c sanity.c */ mkindx.c mycompress.c wd.c
# define DID_ALL
thisdir: mkindx mycompress wd

mkindx: mkindx.o
	$(CC) $(CFLAGS) -o mkindx mkindx.o C_LIBS

mycompress: mycompress.o
	$(CC) $(CFLAGS) -o mycompress mycompress.o C_LIBS

wd: wd.o
	$(CC) $(CFLAGS) -o wd wd.o C_LIBS

# define BINFILES mkindx mycompress wd
#endif

/* generic */
#ifdef OUT_ARCHIVE
# ifndef DID_ALL
thisdir: OUT_ARCHIVE
# endif
#endif

#ifndef MK_TOPDIR
all:
	(cd ..;${MAKE})

#else
check: makefiles
	for i in */[a-z]*.c */[a-z]*.h; \
	do if /bin/ls -l $$i | egrep '^.rw' >/dev/null; \
	   then echo $$i; \
	   fi; \
	done

#endif

#if defined(BINFILES) || defined(O_FILES)
# ifdef O_FILES
clean:
	-rm -f O_FILES
#  ifdef BINFILES
	-rm -f BINFILES
#  endif
# else
clean:
	-rm -f BINFILES
# endif
#endif

#ifdef BINFILES

install: BINFILES
	if [ ! -d ${TOPDIR}/bin ]; then mkdir ${TOPDIR}/bin; fi; \
	for i in BINFILES; do \
	  if [ -f ${TOPDIR}/bin/$$i ]; then\
	    mv -f ${TOPDIR}/bin/$$i ${TOPDIR}/bin/$$i~; \
	  fi;\
	  cp $$i ${TOPDIR}/bin/$$i; \
	done
#endif

#ifdef OUT_ARCHIVE
OUT_ARCHIVE: O_FILES
	-rm -f OUT_ARCHIVE
	ar rcu OUT_ARCHIVE O_FILES
#ifdef RANLIB
	ranlib OUT_ARCHIVE
#endif
#endif

#if defined(C_FILES) && defined(MAKE_DEPEND)
depend: C_FILES
	${MKDEP} INCLUDEOPT C_FILES
#else
depend:
	@echo Warning: no make depend on your system.
#endif
