/*
	Copyright (C) 1991, Marcus J. Ranum. All rights reserved.
*/

#ifndef	lint
static	char	RCSid[] = "$Header: /usr/users/mjr/hacks/umud/RWHO/RCS/mudwho.c,v 1.5 91/05/28 22:39:32 mjr Exp $";
#endif


#include	<stdio.h>
#include	<sys/types.h>
#include	<errno.h>
extern	int	errno;
#include	<ctype.h>
#include	<fcntl.h>
#include	<sys/file.h>
#include	<sys/time.h>
#include	<sys/socket.h>
#include	<netinet/in.h>
#include	<netdb.h>


#define	STREAMPORT		6889

#define	ENVHOST		"MUDWHOSERVER"
#define	ENVPORT		"MUDWHOPORT"


#ifndef	NO_HUGE_RESOLVER_CODE
extern	struct	hostent	*gethostbyname();
#endif

extern	char	*getenv();

main(ac,av)
int	ac;
char	*av[];
{
	struct	sockaddr_in	addr;
	struct	hostent		*hp;
	int			fd;
	char			*p;
	int			red;
	char			rbuf[1024];
	char			*srv = (char *)0;
	int			portnum = STREAMPORT;

	/* setup host address */
	if(ac > 1)
		srv = av[1];
	else
		srv = getenv(ENVHOST);


	/* setup port # if we can */
	if(ac > 2) {
		portnum = atoi(av[2]);
	} else {
		if((p = getenv(ENVPORT)) != (char *)0)
			portnum = atoi(p);
	}


	if(srv == (char *)0) {
		fprintf(stderr,"usage: hostname [or envir %s]\n",ENVHOST);
		exit(1);
	}

	p = srv;
	while(*p != '\0' && (*p == '.' || isdigit(*p)))
		p++;

	/* not all digits or dots */
	if(*p != '\0') {
#ifndef	NO_HUGE_RESOLVER_CODE
		if((hp = gethostbyname(srv)) == (struct hostent *)0) {
			fprintf(stderr,"unknown host %s\n",srv);
			exit(1);
		}

		(void)bcopy(hp->h_addr,(char *)&addr.sin_addr,hp->h_length);
#else
		fprintf(stderr,"must use numerical notation for host name\n");
		exit(1);
#endif
	} else {
		unsigned long	f;

		if((f = inet_addr(srv)) == -1L) {
			fprintf(stderr,"unknown host %s\n",srv);
			exit(1);
		}
		(void)bcopy((char *)&f,(char *)&addr.sin_addr,sizeof(f));
	}

	addr.sin_port = htons(portnum);
	addr.sin_family = AF_INET;

	if((fd = socket(AF_INET,SOCK_STREAM,0)) < 0) {
		perror("socket");
		exit(1);
	}

	if(connect(fd,&addr,sizeof(addr)) < 0) {
		perror("connect");
		exit(1);
	}

	while((red = read(fd,rbuf,sizeof(rbuf))) > 0)
		write(1,rbuf,red);
	exit(0);
}
