/* dbdefs.h */

#ifndef __DBDEFS_H
#define __DBDEFS_H

#ifndef XENIX
extern void *malloc();
extern void *realloc();
extern void free();
#endif				/* XENIX */

extern int depth;

typedef int dbref;		/* offset into db */
typedef int object_flag_type;
typedef int channel_type;

#ifdef DESTROY
extern dbref first_free;	/* pointer to free list */
void free_object();
extern void fix_free_list();
void do_empty();
#define FIX fix_free_list()
#else /* DESTROY */
#define FIX
#endif /* DESTROY */

/* macro to make set string easier to use */
#define SET(a,b) set_string(&(a),b)

/* set macro for compressed strings */

#ifdef COMPRESS
#define SETC(a,b) SET(a,compress(b))
#else
#define SETC(a,b) SET(a,b)
#endif				/* COMPRESS */

/* Updates an objects age */
#define Access(x) (db[(x)].flags |= ACCESSED)

/*-------------------------------------------------------------------------
 * Database access macros
 */

#define Typeof(x) (db[(x)].flags & TYPE_MASK)

#define Name(x)		(db[(x)].name)
#define Flags(x)  	(db[(x)].flags)
#define Toggles(x) 	(db[(x)].toggles)
#define Owner(x)  	(db[(x)].owner)

#define getloc(thing) 	(db[thing].location)
#define getzone(thing) 	(db[thing].zone)

#define Location(x) 	(db[(x)].location)
#define Zone(x)     	(db[(x)].zone)

#define Contents(x) (db[(x)].contents)
#define Next(x)     (db[(x)].next)
#define Home(x)     (db[(x)].exits)
#define Exits(x)    (db[(x)].exits)

#define Key(x)      (db[(x)].key)
#define Enterkey(x) (db[(x)].enterkey)
#define Usekey(x)   (db[(x)].usekey)

#define Pennies(thing) (db[thing].penn)
#define s_Pennies(thing,p) (db[thing].penn=(p))

#define Parent(x)  ((Typeof(x) == TYPE_PLAYER) ? NOTHING : (db[(x)].parent))
#define Powers(x)  (db[(x)].powers)

/* Note that this is a utility to determine the objects which may or may */
/* not be controlled, rather than a strict check for the INHERIT flag */
#define Owns(p,x) (db[(p)].owner == db[(x)].owner)

#define IS(thing,type,flag) ((Typeof(thing)==type) && (Toggles(thing) & flag))

#define Hasflag(x,t,f)     ((Typeof(x) == t) && (Flags(x) & f))

#define GoodObject(x) ((x >= 0) && (x <= db_top))

#define Wizard(x) ((Flags(x) & WIZARD) || God(x))

#ifdef ROYALTY_FLAG 
#define Royalty(x)  (Flags(x) & ROYALTY)
#define Hasprivs(x) (Royalty(x) || Wizard(x))
#else				/* ROYALTY_FLAG */
#define Hasprivs(x) (Wizard(x))
#endif				/* ROYALTY_FLAG */

#define Mobile(x) ((Typeof(x) == TYPE_PLAYER) || (Typeof(x) == TYPE_THING))

#define DestOk(x)	(IS(x, TYPE_THING, THING_DEST_OK))
#define Puppet(x)	(IS(x, TYPE_THING, THING_PUPPET))
#define Alive(x) 	((Typeof(x)==TYPE_PLAYER) || Puppet(x))

#define Audible(x)      (Flags(x) & AUDIBLE)
#define Dark(x)		((Flags(x) & DARK) && (Wizard(x) || !Alive(x)))
#define Debug(x)	(Flags(x) & DEBUGGING)
#define Going(x)	(Flags(x) & GOING)
#define Halted(x)	(Flags(x) & HALT)
#define Haven(x)	(Flags(x) & HAVEN)
#define LinkOk(x)	(Flags(x) & LINK_OK)
#define NoCommand(x)	(Flags(x) & NO_COMMAND)
#define Opaque(x)	(Flags(x) & OPAQUE)
#define Quiet(x)	(Flags(x) & QUIET)
#define IsQuiet(x)      (Quiet(x) || Quiet(Owner(x)))
#define AreQuiet(x,y)   (Quiet(x) || Quiet(y))
#define Safe(x)		(Flags(x) & SAFE)
#define Sticky(x)	(Flags(x) & STICKY)
#define Unfind(x)	(Flags(x) & UNFIND)
#define Visual(x)	(Flags(x) & VISUAL)

#define Connected(x)	(Toggles(x) & PLAYER_CONNECT)
#define Nospoof(x)	(Toggles(Owner(x)) & PLAYER_NOSPOOF)
#define Terse(x)	(Toggles(Owner(x)) & PLAYER_TERSE)
#define Myopic(x)	(Toggles(Owner(x)) & PLAYER_MYOPIC)
#define ShowAnsi(x)	(Toggles(Owner(x)) & PLAYER_ANSI)
#define Suspect(x)  	(IS(x, TYPE_PLAYER, PLAYER_SUSPECT))
#define ZMaster(x)      (IS(x, TYPE_PLAYER, PLAYER_ZONE))

#define Abode(x)	(IS(x, TYPE_ROOM, ROOM_ABODE))
#define Floating(x)	(IS(x, TYPE_ROOM, ROOM_FLOATING))

#ifdef INHERIT_FLAG
#define Inherit(x)   ((Typeof(x) == TYPE_PLAYER) || (Flags(x) & INHERIT) || \
		      (Flags(Owner(x)) & INHERIT) || Wizard(x))
#endif				/* INHERIT_FLAG */

/*--------------------------------------------------------------------------
 * Other db stuff
 */

/* Boolean expressions, for locks */
typedef char boolexp_type;
#define BOOLEXP_AND 0
#define BOOLEXP_OR 1
#define BOOLEXP_NOT 2
#define BOOLEXP_CONST 3
#define BOOLEXP_ATR 4
#define BOOLEXP_IND 5
#define BOOLEXP_CARRY 6
#define BOOLEXP_IS 7
#define BOOLEXP_OWNER 8
#define BOOLEXP_EVAL 9

struct boolexp {
  boolexp_type type;		/* and, or, not, indirect, is, carry, etc. */
  struct boolexp *sub1;		/* first part of lock */
  struct boolexp *sub2;		/* second part of lock */
  dbref thing;			/* thing refers to an object */
  struct boolatr *atr_lock;
};

#define TRUE_BOOLEXP ((struct boolexp *) 0)

/* lock types */
#define BASICLOCK 0
#define USELOCK 1
#define ENTERLOCK 2

/* special dbref's */
#define NOTHING (-1)		/* null dbref */
#define AMBIGUOUS (-2)		/* multiple possibilities, for matchers */
#define HOME (-3)		/* virtual room, represents mover's home */

struct object {
  const char *name;
  dbref location;		/* pointer to container */
                                /* for exits, pointer to destination */
                                /* for rooms, pointer to drop-to */
  dbref contents;		/* pointer to first item */
  dbref exits;			/* pointer to first exit for rooms */
                                /* pointer to home for things and players */
				/* pointer to room it's in for exits. */
  dbref next;			/* pointer to next in contents/exits chain */
  dbref parent;			/* pointer to last person paged for player*/
				/* parent object for everything else */
  
  /* the following is used for pickups for things, entry for exits */
  struct boolexp *key;		/* if not NOTHING, must have this to do op */
  struct boolexp *usekey;      /* page lock for players, use lock for things */
  struct boolexp *enterkey;     /* enter key */

  dbref owner;			/* who controls this object */
  dbref zone;			/* zone master object number */
  int penn;			/* number of pennies object contains */
#if (CHAT_SYSTEM != 0)
  channel_type channels;
#endif
  object_flag_type flags;
  object_flag_type toggles;
  object_flag_type powers;
  ALIST *list;
};

struct dblist {			/* used by routines in util.c */
	dbref obj;
	struct dblist *next;
};

extern struct object *db;
extern dbref db_top;

extern const char *alloc_string();
extern dbref new_object();
extern void putstring();
extern dbref getref();
extern void putref();
extern const char *getstring_noalloc();
extern struct boolexp *getboolexp();
extern void putboolexp();
extern int db_write_object();
extern dbref db_write();
extern dbref db_read();
/* Warning: destroys existing db contents! */
extern void free_bool();
extern struct boolexp *dup_bool();
extern struct boolexp *alloc_bool();
extern void free_boolexp();
extern void db_free();
extern dbref parse_dbref();

#define DOLIST(var, first)\
    for((var) = (first); (var) != NOTHING; (var) = db[(var)].next)

#define PUSH(thing, locative) \
    ((db[(thing)].next = (locative)), (locative) = (thing))

#ifdef USE_MAILER
struct mail {
  struct mail *next;
  struct mail *prev;
  dbref to;
  dbref from;
  const char *message;
  const char *time;
  int read;
};
#endif				/* USE_MAILER */

/* log types */
#define LT_ERR    0
#define LT_CMD    1
#define LT_WIZ    2
#define LT_CONN   3
#define LT_TRACE  4
#define LT_RPAGE  5
#define LT_CHECK  6
#define LT_HUH    7

/* tokens for locks */
#define NOT_TOKEN '!'
#define AND_TOKEN '&'
#define OR_TOKEN '|'
#define AT_TOKEN '@'
#define IN_TOKEN '+'
#define IS_TOKEN '='
#define OWNER_TOKEN '$'

#endif				/* __DBDEFS_H */
