/* $Id: macro.h,v 30000.20 1993/05/04 22:39:22 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef MACRO_H
#define MACRO_H

#include "world.h"

typedef struct Macro {
    char *name;
    struct ListEntry *numnode;           /* node in list by number */
    struct ListEntry *trignode;          /* node in list by trigger priority */
    struct ListEntry *hooknode;          /* node in list by hook */
    struct ListEntry *bucketnode;        /* node in list in hash bucket */
    struct Macro *tnext;                 /* temp list ptr for collision/death */
    char *trig, *hargs, *bind, *body;
    void NDECL((*func));                 /* ptr to func, saves lookup */
    int hook;                            /* at least 32 bits anywhere TF runs */
    struct World *world;                 /* only trigger on text from here */
    int pri, num;
    short attr, prob, shots, invis, temp, dead;
} Macro;

enum Hooks {
  H_ACTIVITY,
  H_BACKGROUND,
  H_BAMF,
  H_CONFAIL,
  H_CONFLICT,
  H_CONNECT,
  H_DISCONNECT,
  H_HISTORY,
  H_KILL,
  H_LOAD,
  H_LOADFAIL,
  H_LOG,
  H_LOGIN,
  H_MAIL,
  H_MORE,
  H_PENDING,
  H_PROCESS,
  H_REDEF,
  H_RESIZE,
  H_RESUME,
  H_SEND,
  H_SHADOW,
  H_SHELL,
  H_WORLD,
  NUM_HOOKS                              /* not a hook, but a count */
};

extern void    NDECL(init_macros);
extern short   FDECL(parse_attrs,(char *args));
extern Macro  *FDECL(macro_spec,(char *args));
extern Macro  *FDECL(find_macro,(char *name));
extern Macro  *FDECL(new_macro,(char *name, char *trig, char *binding,
    int hook, char *hargs, char *body, struct World *world, int pri, int prob,
    int attr, int shots, int invis));
extern void    FDECL(add_macro,(struct Macro *macro));
extern int     FDECL(install_bind,(struct Macro *spec));
extern int     FDECL(add_hook,(char *name, char *body));
extern int     FDECL(do_add,(struct Macro *spec));
extern int     FDECL(do_edit,(struct Macro *spec));
extern int     FDECL(remove_macro,(char *args, int attr, int byhook));
extern void    NDECL(nuke_dead_macros);
extern void    FDECL(kill_macro,(struct Macro *macro));
extern int     FDECL(purge_macro,(struct Macro *spec));
extern int     FDECL(remove_by_number,(char *args));
extern void    FDECL(remove_world_macros,(World *w));
extern int     FDECL(save_macros,(char *args));
extern int     FDECL(list_macros,(char *args));
extern int     FDECL(do_macro,(Macro *macro, char *args));
extern short   VDECL(do_hook,(int indx, char *fmt, char *argfmt, ...));
extern char   *FDECL(macro_body,(char *name));
extern short   FDECL(check_trigger,(char *s));
extern TOGGLER(change_hilite);
extern int     FDECL(rpricmp,(CONST Macro *m1, CONST Macro *m2));

#endif /* MACRO_H */
