/* $Id: search.h,v 30000.20 1993/05/04 22:39:32 kkeys Exp $ */
/******************************************************************
 * Copyright 1993 by Ken Keys.
 * Permission is granted to obtain and redistribute this code freely.
 * All redistributions must contain this header.  You may modify this
 * software, but any redistributions of modified code must be clearly
 * marked as having been modified.
 ******************************************************************/

#ifndef SEARCH_H
#define SEARCH_H

/**********************************************
 * hash table and linked list routines        *
 **********************************************/

typedef struct ListEntry {
    struct ListEntry *next, *prev;
    GENERIC *data;
} ListEntry;

typedef struct List {
    ListEntry *head, *tail;
} List;

typedef struct HashTable {
    int size;
    int FDECL((*cmp),(CONST char *, CONST char *));
    List **bucket;
} HashTable;

#define init_queue(q)  init_list(q)
#define dequeue(q)         ((Aline *)((q)->tail ? \
                             unlist((q)->tail, (q)) : NULL))
#define enqueue(q, aline)  inlist((aline), (q), NULL)

extern void       FDECL(init_list,(List *list));
extern GENERIC   *FDECL(unlist,(ListEntry *node, List *list));
extern ListEntry *FDECL(inlist,(GENERIC *data, List *list, ListEntry *where));
extern ListEntry *FDECL(sinsert,(GENERIC *data, List *list, Cmp *cmp));
extern void       FDECL(queuequeue,(Queue *src, Queue *dest));
extern void       FDECL(free_queue,(Queue *q));
extern void       FDECL(hash_remove,(ListEntry *node, HashTable *table));
extern ListEntry *FDECL(hash_insert,(GENERIC *data, HashTable *table));
extern GENERIC   *FDECL(hash_find,(char *name, HashTable *table));
extern void       FDECL(init_hashtable,(HashTable *table, int size,
                      int FDECL((*cmp),(CONST char *, CONST char *))));
extern int        FDECL(binsearch,(char *key, GENERIC *base, int nel, int size,
                      int FDECL((*cmp),(CONST char *, CONST char *))));

#endif /* SEARCH_H */

