/*
 * ------------------------------------------------------------------
 * Bitmaps.cc - Custom built-in bitmaps
 * Created by Robert Heller on Sat Jun 17 16:30:15 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: Bitmaps.cc,v $
// Revision 1.2  1995/06/18  20:07:38  heller
// Added Left and Right bitmaps
//
// Revision 1.1  1995/06/17  20:45:15  heller
// Initial revision
//
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */
static char rcsid[] = "$Id: Bitmaps.cc,v 1.2 1995/06/18 20:07:38 heller Exp $";

#include <iostream.h>
#include <fstream.h>
#include <pfstream.h>
#include <strstream.h>
#include <tclExtend.h>
#include <tk.h>
#include <tkX.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

#include <Center.xbm>
#include <Down.xbm>
#include <DownLeft.xbm>
#include <DownRight.xbm>
#include <Up.xbm>
#include <UpLeft.xbm>
#include <UpRight.xbm>
#include <Left.xbm>
#include <Right.xbm>
#include <door.xbm>
#include <doorlocked.xbm>
#include <dooroneway.xbm>
#include <doorsecret.xbm>
#include <rampdown.xbm>
#include <rampup.xbm>
#include <stairsdown.xbm>
#include <stairsup.xbm>

static inline int DefineBitmap(Tcl_Interp *interp,char *name,char *bits,
		        unsigned int width,unsigned int height)
{
	Tk_Uid uid = Tk_GetUid(name);
	return Tk_DefineBitmap(interp,uid,bits,width,height);
}

int Bitmaps_Init(Tcl_Interp *interp)
{
	if (DefineBitmap(interp,"Center",Center_bits,Center_width,Center_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"Down",Down_bits,Down_width,Down_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"DownLeft",DownLeft_bits,DownLeft_width,DownLeft_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"DownRight",DownRight_bits,DownRight_width,DownRight_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"Up",Up_bits,Up_width,Up_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"UpLeft",UpLeft_bits,UpLeft_width,UpLeft_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"UpRight",UpRight_bits,UpRight_width,UpRight_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"Left",Left_bits,Left_width,Left_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"Right",Right_bits,Right_width,Right_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"door",door_bits,door_width,door_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"doorlocked",doorlocked_bits,doorlocked_width,doorlocked_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"dooroneway",dooroneway_bits,dooroneway_width,dooroneway_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"doorsecret",doorsecret_bits,doorsecret_width,doorsecret_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"rampdown",rampdown_bits,rampdown_width,rampdown_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"rampup",rampup_bits,rampup_width,rampup_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"stairsdown",stairsdown_bits,stairsdown_width,stairsdown_height) != TCL_OK)
		return TCL_ERROR;
	if (DefineBitmap(interp,"stairsup",stairsup_bits,stairsup_width,stairsup_height) != TCL_OK)
		return TCL_ERROR;
	return TCL_OK;
}	
