/*
 * ------------------------------------------------------------------
 * Character.h - Character class defs
 * Created by Robert Heller on Sat Feb 25 16:36:56 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: Character.h,v $
 * Revision 1.5  1995/06/18  17:38:55  heller
 * Updated the Postscript code (cleaned it up, added RPGDict, etc.)
 *
 * Revision 1.4  1995/03/23  23:40:24  heller
 * Make CharacterHandles a static member
 *
 * Revision 1.3  1995/03/17  06:35:57  heller
 * Add missing slots for Alignment, Sex, and Age
 *
 * Revision 1.2  1995/02/28  03:35:22  heller
 * Installed Postscript code
 *
 * Revision 1.1  1995/02/26  04:41:53  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#ifndef _CHARACTER_H_
#define _CHARACTER_H_

#include <tcl.h>
#include <tclExtend.h>
#include <String.h>
#include <iostream.h>

class Character {
public:
	enum PrintType {text, html, postscript};
	String Name, Player, Race, ChClass;
	String Alignment, Sex;
	String Comments;
	int   ExperiencePoints;
	static void_pt Handles;
private:
	short int hitpoints, age;
	signed char strength,intelligence,wisdom,
		    dexterity,constitution,chrisma,
		    exceptional_strength,level,hdie,ndie,maxdie;
	void _Character(int s, int i, int w, int d, int c, int ch,
	                int es, int l, int hd, int nd, int md,
	                String n, String p, String r, String chc, 
			String align, String sex, int ag,String com);
public:
	inline int HitPoints() {return (int)hitpoints;}
	inline int Age() {return (int)age;}
	inline int Strength() {return (int) strength;}
	inline int Intelligence() {return (int) intelligence;}
	inline int Wisdom() {return (int) wisdom;}
	inline int Dexterity() {return (int) dexterity;}
	inline int Constitution() {return (int) constitution;}
	inline int Chrisma() {return (int) chrisma;}
	inline int ExceptionalStrength() {return (int) exceptional_strength;}
	inline int Level() {return (int) level;}
	void AdvanceLevel();
	Character()
		//          s i w d c ch es l hd nd md
		{_Character(0,0,0,0,0, 0, 0,1, 6, 1, 1,
		//	    n        p        r               chc
			    String(),String(),String("Human"),String("npc"),
		//          align,sex,ag,com
			    String(),String(),0,String());
		}
	Character(int s, int i,int w,int d,int c,int ch,int es = 0,
	          int l = 1,int hd = 6,int nd = 1,int md = 1,
		  String n = String(), String p =  String(),
		  String r = String("Human"), String chc = String("npc"),
		  String align = String(),String sex = String(),int ag = 0,
		  String com = String())
		{_Character(s,i,w,d,c,ch,es,l,hd,nd,md,n,p,r,chc,align,sex,ag,
			    com);}
	Character(int s, int i,int w,int d,int c,int ch,
	          int l = 1,int hd = 6,int nd = 1,int md = 1,
		  String n = String(), String p =  String(),
		  String r = String("Human"), String chc = String("npc"),
		  String align = String(),String sex = String(),int ag = 0,
		  String com = String())
		{_Character(s,i,w,d,c,ch,0,l,hd,nd,md,n,p,r,chc,align,sex,ag,
			    com);}
	Character(int s, int i,int w,int d,int c,int ch,
	          int l = 1,int hd = 6,int md = 1,
		  String n = String(), String p =  String(),
		  String r = String("Human"), String chc = String("npc"),
		  String align = String(),String sex = String(),int ag = 0,
		  String com = String())
		{_Character(s,i,w,d,c,ch,0,l,hd,1,md,n,p,r,chc,align,sex,ag,
			    com);}
	~Character();
	int ReadFromFile(char *filename);
	int WriteToFile(char *filename);
	int PrintToFile(char *filename,PrintType typ = text);
	int TclFunction(Tcl_Interp *interp,int argc, char *argv[]);
};

extern String& PSQuoteXnewline(String& source);

#endif // _CHARACTER_H_

