/*
 * ------------------------------------------------------------------
 * Dice.h - Dice class definations
 * Created by Robert Heller on Sat Feb 25 18:00:40 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: Dice.h,v $
 * Revision 1.3  1995/03/18  20:03:50  heller
 * Added handle magic
 *
 * Revision 1.2  1995/02/26  14:56:55  heller
 * Add I/O functions and tcl interface code
 *
 * Revision 1.1  1995/02/25  23:39:20  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#ifndef _DICE_H_
#define _DICE_H_

#include <tcl.h>
#include <iostream.h>
#include <RndInt.h>
#include <bool.h>

class Dice {
private:
	RNG *gen;
	RandomInteger *dice;
	unsigned int nsides, ndice;
	void _Dice();
public:
	Dice(unsigned int ns,unsigned int nd = 1)
	    {nsides = ns;ndice = nd;gen = NULL;dice = NULL;_Dice();}
	Dice() {nsides = 0;ndice = 0; dice = NULL; gen = NULL;}
	~Dice();
	unsigned int Roll();
	int TclFunction(Tcl_Interp *interp,int argc, char *argv[]);
	friend ostream& operator << (ostream& s,Dice& d);
	friend istream& operator >> (istream& s,Dice& d);
	inline  bool TypeOfDice(unsigned int& ns,unsigned int& nd)
		{
			ns = nsides;
			nd = ndice;
			if (dice == NULL) return(FALSE); 
			else return(TRUE);
		}
};
	

#endif // _DICE_H_

