/*
 * ------------------------------------------------------------------
 * Master.cc - Master Class implementations
 * Created by Robert Heller on Fri Mar 17 11:39:02 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: Master.cc,v $
// Revision 1.14  1995/07/02  17:43:48  heller
// Fix Memory "anti-leak" in ~Dungeon()
//
// Revision 1.13  1995/07/02  02:09:50  heller
// Add in EncumbrenceList::Handlize()
// and use it in FixUpEncumbrenceLists()
//
// Revision 1.12  1995/06/24  21:59:58  heller
// Fix Tcl_AppendResult call error (missing "(char *)NULL")
//
// Revision 1.11  1995/06/24  16:43:21  heller
// Fix hash table handling in ~Dungeon()
//
// Revision 1.10  1995/06/24  14:57:32  heller
// Fix problem with Dungeon's "space" option (return null space properly)
//
// Revision 1.9  1995/06/18  16:20:34  heller
// Added Postscript code, including Postscript utility functions
// Split "small" classes out of Master.cc into their own source files.
// Completed I/O code for class Game (including Postscript)
//
// Revision 1.8  1995/04/11  23:15:41  heller
// Misc. typos.
// Add in basic Game class code
//
// Revision 1.7  1995/04/11  02:42:44  heller
// Add Tcl_Interp* forms for some of the Put() funs (handle expansion).
// Add Up and Down exit directions.
// Add pointer to treasure hash table hack to Dungeon::ReadFromFile().
// Minor error message fixes in createSpace().
//
// Revision 1.6  1995/03/23  00:39:59  heller
// Added HTMLPut and TEXTPut methods
//
// Revision 1.5  1995/03/22  00:19:18  heller
// Finish Dungeon I/O
// (Includes additional adjustments to other I/O handlers)
//
// Revision 1.4  1995/03/21  04:25:14  heller
// Added a big chunk of Dungeon
//
// Revision 1.3  1995/03/19  21:50:00  heller
// Add Space implementation
//
// Revision 1.2  1995/03/19  05:06:12  heller
// Add DressingList, TreasureList, and TrickList
//
// Revision 1.1  1995/03/18  05:49:30  heller
// Initial revision
//
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char rcsid[] = "$Id: Master.cc,v 1.14 1995/07/02 17:43:48 heller Exp $";

#include <iostream.h>
#include <fstream.h>
#include <pfstream.h>
#include <strstream.h>
#include <Master.h>
#include <Monster.h>
#include <Character.h>
#include <tclExtend.h>
#include <tk.h>
#include <tkX.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

String& PSQuoteXnewline(String& source)
{
	static const Regex PSQChars = "[\\\\(\\)\\%\n]";
	String b = "", a = "", m = "";
	static String result;
	result = "";
	for (String temp = source;temp != "";temp = a)
	{
		b = temp.before(PSQChars);
		m = temp.at(PSQChars);
		a = temp.after(PSQChars);
		result += b;
		if (m == "\n")
		{
			result += "\\";
			result += m;
			result += " ";
		} else if (m != "")
		{
			result += "\\";
			result += m;
		} else  result += temp;
	}
	return result;
}

int PointerToHandle(Tcl_Interp *interp,void_pt handles,void* pointer,char* result)
{
	int walkkey;
	void_pt entry;
	walkkey = -1;
	while ((entry = Tcl_HandleWalk(handles,&walkkey)) != NULL)
	{
		if ((*((void**)entry)) == pointer)
		{
			Tcl_WalkKeyToHandle(handles,walkkey,result);
			return TCL_OK;
		}
	}
	Tcl_AppendResult(interp,"Cannot map pointer to handle",(char*) NULL);
	result[0] = '\0';
	return TCL_ERROR;
}

Space*& Dungeon::operator () (int l,int x,int y)
{
	if (spaces == NULL)
	{
		spaces = new Space***[Levels];
		for (int il = 0; il < Levels; il++) spaces[il] = NULL;
	}
	Space ***level = spaces[l];
	if (level == NULL)
	{
		level = spaces[l] = new Space**[YSize];
		for (int iy = 0;iy < YSize;iy++) level[iy] = NULL;
	}
	Space **row = level[y];
	if (row == NULL)
	{
		row = level[y] = new Space*[XSize];
		for (int ix = 0;ix < XSize;ix++) row[ix] = NULL;
	}
	return row[x];
}
		
	
	

Dungeon::Dungeon(String n,String c,int l, int x, int y)
{
	spaces = NULL;
	NPCList = NULL;
	MasterMonsterList = NULL;
	MasterTrickList = NULL;
	MasterTreasureList = NULL;
	Levels = l;
	XSize = x;
	YSize = y;
	Name = n;
	Comments = c;
	treasuresht = FALSE;
}

Dungeon::~Dungeon()
{
	if (spaces == NULL) return;
	for (int l = 0; l < Levels; l++)
	{
		if (spaces[l] == NULL) continue;
		Space ***level = spaces[l];
		for (int y = 0; y < YSize; y++)
		{
			if (level[y] == NULL) continue;
			Space **row = level[y];
			delete row;
		}
		delete level;
	}
	delete spaces;
	if (treasuresht) Tcl_DeleteHashTable(&treasures);
}

static void FixUpEncumbrenceHandles(EncumbrenceList *e,Tcl_HashTable *treasures,Tcl_Interp *interp)
{
	while (e != NULL)
	{
		e->Handlize(interp);
		if (e->Handle != "")
		{
			Tcl_HashEntry *he = Tcl_FindHashEntry(treasures,
							      (char*)e->Handle);
			if (he != NULL)
			{
				e->Handle = (char*)(Tcl_GetHashValue(he));
			} else  e->Handle = "";
		}
		e = e->NextEncumbrence;
	}
}

static void FixUpTrickHandles(TrickList *l,Tcl_HashTable *tricks)
{
	while (l != NULL)
	{
		if (l->Handle != "")
		{
			Tcl_HashEntry *he = Tcl_FindHashEntry(tricks,
							      (char*)l->Handle);
			if (he != NULL)
			{
				l->Handle = (char*)(Tcl_GetHashValue(he));
			} else  l->Handle = "";
		}
		l = l->NextTrick;
	}
}

static void FixUpTreasureHandles(TreasureList *e,Tcl_HashTable *treasures)
{
	while (e != NULL)
	{
		if (e->Handle != "")
		{
			Tcl_HashEntry *he = Tcl_FindHashEntry(treasures,
							      (char*)e->Handle);
			if (he != NULL)
			{
				e->Handle = (char*)(Tcl_GetHashValue(he));
			} else  e->Handle = "";
		}
		e = e->NextTreasure;
	}
}

static void FixUpCharacterHandles(CharacterList *e,Tcl_HashTable *characters,
				  Tcl_HashTable *treasures,Tcl_Interp *interp)
{
	while (e != NULL)
	{
		if (e->Handle != "")
		{
			Tcl_HashEntry *he = Tcl_FindHashEntry(characters,
							      (char*)e->Handle);
			if (he != NULL)
			{
				e->Handle = (char*)(Tcl_GetHashValue(he));
			} else  e->Handle = "";
		}
		FixUpEncumbrenceHandles(e->Encumbrences,treasures,interp);
		e = e->NextCharacter;
	}
}

static void FixUpMonsterHandles(Tcl_Interp *interp,MonsterList *e,
				Tcl_HashTable *monsters,
				Tcl_HashTable *characters)
{
	while (e != NULL)
	{
		if (e->Handle != "")
		{
			Tcl_HashTable *table = NULL;
			if (Tcl_VarEval(interp,(char*)e->Handle," type",(char*)NULL) == TCL_OK)
			{
				if (strcmp(interp->result,"Monster") == 0)
				{
					table = monsters;
				} else if (strcmp(interp->result,"Character") == 0)
				{
					table = characters;
				} else table = NULL;
			}					
			Tcl_HashEntry *he = NULL;
			if (table != NULL) he = Tcl_FindHashEntry(table,
							      (char*)e->Handle);
			if (he != NULL)
			{
				e->Handle = (char*)(Tcl_GetHashValue(he));
			} else  e->Handle = "";
		}
		e = e->NextMonster;
	}
}

int Dungeon::ReadFromFile(Tcl_Interp *interp,char *filename,Tcl_HashTable **trtab)
{
	int temp;
	ifstream stream(filename);
	stream >> temp;
	stream.get();
	Name = "";
	while (temp > 0)
	{
		Name += stream.get();
		temp--;
	}
	stream >> temp;
	stream.get();
	Comments = "";
	while (temp > 0)
	{
		Comments += stream.get();
		temp--;
	}
	while (stream.get() != '{') ;
	String oldhandle;
	static char newhandle[32];
	Tcl_HashTable tricks,monsters,characters;
	Tcl_InitHashTable(&tricks,TCL_STRING_KEYS);
	MasterTrickList = NULL;
	TrickList **trickslot;
	trickslot = &MasterTrickList;
	while (stream.peek() != '}')
	{
		int newPtr;
		stream >> oldhandle;
		Tcl_HashEntry *he = Tcl_CreateHashEntry(&tricks,
							(char*)oldhandle,
							&newPtr);
		Trick *newtrick;
		//while (stream.peek() == ' ') stream.get();
		if (newPtr)
		{
			if (Tcl_VarEval(interp,"Trick",(char*) NULL) != TCL_OK)
				return 0;
			strcpy(newhandle,interp->result);
			char *newh = new char[strlen(newhandle)+1];
			strcpy(newh,newhandle);
			Tcl_SetHashValue(he,(ClientData)newh);
		} else strcpy(newhandle,(char*)Tcl_GetHashValue(he));
		Trick **th = (Trick **) Tcl_HandleXlate(interp,Trick::Handles,newhandle);
		newtrick = *th;
		stream >> *newtrick;
		TrickList *newtl = new TrickList(newtrick->Name,"",newhandle,NULL);
		newtl->Handlize(interp);
		*trickslot = newtl;
		trickslot = &newtl->NextTrick;
	}
	while (stream.get() != '{') ;
	Tcl_InitHashTable(&treasures,TCL_STRING_KEYS);
	treasuresht = TRUE;
	MasterTreasureList = NULL;
	TreasureList **treasureslot;
	treasureslot = &MasterTreasureList;
	while (stream.peek() != '}')
	{
		int newPtr;
		stream >> oldhandle;
		Tcl_HashEntry *he = Tcl_CreateHashEntry(&treasures,
							(char*)oldhandle,
							&newPtr);
		Treasure *newtreasure;
		//while (stream.peek() == ' ') stream.get();
		if (newPtr)
		{
			if (Tcl_VarEval(interp,"Treasure",(char*) NULL) != TCL_OK)
				return 0;
			strcpy(newhandle,interp->result);
			char *newh = new char[strlen(newhandle)+1];
			strcpy(newh,newhandle);
			Tcl_SetHashValue(he,(ClientData)newh);
		} else strcpy(newhandle,(char*)Tcl_GetHashValue(he));
		Treasure **th = (Treasure **) Tcl_HandleXlate(interp,Treasure::Handles,newhandle);
		newtreasure = *th;
		stream >> *newtreasure;
		TreasureList *newtl = new TreasureList(newtreasure->Name,"",newhandle,NULL);;
		newtl->Handlize(interp);
		*treasureslot = newtl;
		treasureslot = &newtl->NextTreasure;
	}
	while (stream.get() != '{') ;
	Tcl_InitHashTable(&characters,TCL_STRING_KEYS);
	NPCList = NULL;
	CharacterList **characterslot;
	characterslot = &NPCList;
	while (stream.peek() != '}')
	{
		//while (stream.peek() == ' ') stream.get();
		int newPtr;
		if (Tcl_VarEval(interp,"CharacterList",(char*) NULL) != TCL_OK)
			return 0;
		char tlhand[32];
		strcpy(tlhand,interp->result);
		CharacterList *newtl;
		CharacterList **tl = (CharacterList **) Tcl_HandleXlate (interp,CharacterList::Handles,tlhand);
		newtl = *tl;
		stream >> *newtl;
		oldhandle = newtl->Handle;
		Tcl_HashEntry *he = Tcl_CreateHashEntry(&characters,
							(char*)oldhandle,
							&newPtr);
		if (newPtr)
		{
			if (Tcl_VarEval(interp,"Character",(char*) NULL) != TCL_OK)
				return 0;
			strcpy(newhandle,interp->result);
			if (Tcl_VarEval(interp,newhandle," read ",(char*)newtl->File,(char*) NULL) != TCL_OK)
				return 0;
			char *newh = new char[strlen(newhandle)+1];
			strcpy(newh,newhandle);
			Tcl_SetHashValue(he,(ClientData)newh);
		} else strcpy(newhandle,(char*)Tcl_GetHashValue(he));
		newtl->Handle = newhandle;
		*characterslot = newtl;
		characterslot = &newtl->NextCharacter;
		FixUpEncumbrenceHandles(newtl->Encumbrences,&treasures,interp);
	}
	while (stream.get() != '{') ;
	Tcl_InitHashTable(&monsters,TCL_STRING_KEYS);
	MasterMonsterList = NULL;
	MonsterList **monsterslot;
	monsterslot = &MasterMonsterList;
	while (stream.peek() != '}')
	{
		int newPtr;
		if (Tcl_VarEval(interp,"MonsterList",(char*) NULL) != TCL_OK)
			return 0;
		char tlhand[32];
		strcpy(tlhand,interp->result);
		MonsterList *newtl;
		MonsterList **tl = (MonsterList **) Tcl_HandleXlate(interp,MonsterList::Handles,tlhand);
		newtl = *tl;
		stream >> *newtl;
		oldhandle = newtl->Handle;
		Tcl_HashEntry *he = Tcl_CreateHashEntry(&monsters,
							(char*)oldhandle,
							&newPtr);
		if (newPtr)
		{
			if (Tcl_VarEval(interp,"Monster",(char*) NULL) != TCL_OK)
				return 0;
			strcpy(newhandle,interp->result);
			if (Tcl_VarEval(interp,newhandle," read ",(char*)newtl->File,(char*) NULL) != TCL_OK)
				return 0;
			char *newh = new char[strlen(newhandle)+1];
			strcpy(newh,newhandle);
			Tcl_SetHashValue(he,(ClientData)newh);
		} else strcpy(newhandle,(char*)Tcl_GetHashValue(he));
		newtl->Handle = newhandle;
		while (stream.peek() == ' ') stream.get();
		*monsterslot = newtl;
		monsterslot = &newtl->NextMonster;
	}
	stream.get();
	if (spaces != NULL)
	{
		for (int l = 0; l < Levels; l++)
		{
			if (spaces[l] == NULL) continue;
			Space ***level = spaces[l];
			for (int y = 0; y < YSize; y++)
			{
				if (level[y] == NULL) continue;
				Space **row = level[y];
				for (int x = 0; x < XSize; x++)
				{
					if (row[x] == NULL) continue;
					else delete row[x];
				}
				delete row;
			}
			delete level;
		}
		delete spaces;
		spaces = NULL;
	}
	stream >> Levels >> XSize >> YSize;
	while (stream.get() != '{') ;
	for (int l = 0; l < Levels; l++)
	{
	  while (stream.get() != '{') ;
	  for (int y = 0; y < YSize; y++)
	  {
	    while (stream.get() != '{') ;
	    for (int x = 0; x < XSize; x++)
	    {
	      while (stream.get() != '{') ;
	      if (stream.peek() != '}')
	      {
		if (Tcl_VarEval(interp,"Space",(char*) NULL) != TCL_OK)
			return 0;
		char handle[32];
		strcpy(handle,interp->result);
		Space **h = (Space **) Tcl_HandleXlate (interp,Space::Handles,handle);
		Space *sp = *h;
		stream >> *sp;
		sp->HandlizePointers(interp);
		FixUpTrickHandles(sp->Tricks,&tricks);
		FixUpTreasureHandles(sp->Treasures,&treasures);
		FixUpMonsterHandles(interp,sp->Monsters,&monsters,&characters);
		(*this)(l,x,y) = sp;
	      }
	      while (stream.peek() != '}') stream.get();
	      stream.get();
	    }
	    while (stream.peek() != '}') stream.get();
	    stream.get();
	  }
	  while (stream.peek() != '}') stream.get();
	  stream.get();
	}
	while (stream.peek() != '}') stream.get();
	stream.get();
	if (trtab == NULL)
	{
		Tcl_DeleteHashTable(&treasures);
		treasuresht = FALSE;
	}
	else	*trtab = &treasures;
	Tcl_DeleteHashTable(&tricks);
	Tcl_DeleteHashTable(&monsters);
	Tcl_DeleteHashTable(&characters);
	return 1;
}

int Dungeon::WriteToFile(Tcl_Interp *interp,char *filename)
{
	ofstream stream(filename);
	stream << Name.length() << " " << Name << endl;
	if (!stream) return 0;
	stream << Comments.length() << " " << Comments << endl;
	if (!stream) return 0;
	stream << "{";
	if (!stream) return 0;
	for (TrickList *tr = MasterTrickList; tr != NULL; tr = tr->NextTrick)
	{
		
		void_pt ptr = Tcl_HandleXlate(interp,Trick::Handles,tr->Handle);
		if (ptr == NULL) continue;
		Trick *trp = *((Trick**)ptr);
		stream << tr->Handle << " " << *trp;
		if (!stream) return 0;
		if (tr->NextTrick != NULL) stream << endl;
		
	}
	stream << "}" << endl;
	if (!stream) return 0;
	stream << "{";
	if (!stream) return 0;
	for (TreasureList *t = MasterTreasureList; t != NULL; t = t->NextTreasure)
	{
		void_pt ptr = Tcl_HandleXlate(interp,Treasure::Handles,t->Handle);
		if (ptr == NULL) continue;
		Treasure *trp = *((Treasure**)ptr);
		stream << t->Handle << " " << *trp;
		if (!stream) return 0;
		stream << endl;
	}
	stream << "}" << endl;
	if (!stream) return 0;
	stream << "{";
	if (!stream) return 0;
	for (CharacterList *np = NPCList; np != NULL; np = np->NextCharacter)
	{
		stream << *np;
		if (!stream) return 0;
		if (np->NextCharacter != NULL) stream << " ";
	}
	stream << "}" << endl;
	if (!stream) return 0;
	stream << "{";
	if (!stream) return 0;
	for (MonsterList *m = MasterMonsterList; m != NULL; m = m->NextMonster )
	{
		stream << *m;
		if (!stream) return 0;
		stream << " ";
	}
	stream << "}" << endl;
	if (!stream) return 0;
	stream << Levels << " " << XSize << " " << YSize << endl;
	if (!stream) return 0;
	stream << "{";
	if (!stream) return 0;
	for (int l = 0; l < Levels; l++)
	{
		Space ***level = NULL;
		stream << "{";
		if (!stream) return 0;
		if (spaces != NULL) level = spaces[l];
		for (int y = 0; y < YSize; y++)
		{
			Space **row = NULL;
			stream << "{";
			if (!stream) return 0;
			if (level != NULL) row = level[y];
			for (int x = 0; x < XSize; x++)
			{
				if (row == NULL) stream << "{}";
				else if (row[x] == NULL) stream << "{}";
				else stream << "{" << *row[x] << " }";
				if (!stream) return 0;
				if ((x + 1) < XSize) stream << " ";
			}
			stream << "}" << endl;
			if (!stream) return 0;
		}
		stream << "}" << endl;
		if (!stream) return 0;
	}
	stream << "}" << endl;	
	if (!stream) return 0;
	return 1;
}

static void TxtDungeonHead(ostream& out,String name,String comments,int l, int xs,int ys)
{
	out << "Name: " << name << endl;
	out << "Size: " << l
	    << " levels of " << xs << " by " << ys 
	    << " squares" << endl;
	out << comments  << endl << endl;
}

static void TxtDungeonNPCs(ostream& out,Tcl_Interp *interp,CharacterList *npcs)
{
	if (npcs == NULL) return;
	out << "Non Playing Characters:" << endl;
	for (CharacterList *ch = npcs; ch != NULL; ch = ch->NextCharacter)
	{
		ch->TEXTPut(out,interp);
	}
}


static void TxtDungeonMonsters(ostream& out,Tcl_Interp *interp,MonsterList *mons)
{
	if (mons == NULL) return;
	out << "Monsters:" << endl;
	for (MonsterList *mon = mons; mon != NULL; mon = mon->NextMonster)
	{
		mon->TEXTPut(out,interp);
	}
}


static void TxtDungeonTricks(ostream& out,Tcl_Interp *interp,TrickList *tricks)
{
	if (tricks == NULL) return;
	out << "Tricks:" << endl;
	for (TrickList *trick = tricks; trick != NULL; trick = trick->NextTrick)
	{
		trick->TEXTPut(out,interp);
	}
}


static void TxtDungeonTreasures(ostream& out,Tcl_Interp *interp,TreasureList *treasures)
{
	if (treasures == NULL) return;
	out << "Treasures:" << endl;
	for (TreasureList *treasure = treasures; treasure != NULL; treasure = treasure->NextTreasure)
	{
		treasure->TEXTPut(out,interp);
	}
}


static void HTMLDungeonHead(ostream& out,String name,String comments,int l, int xs,int ys)
{
	out << "<title>" << name << "</title>" << endl;
	out << "<h1>" << name << "</h1><br>" << endl;
	out << "<h1>" << "Size: " << l
	    << " levels of " << xs << " by " << ys << " squares" 
	    << "</h1><br>" << endl;
	out << "<p>" <<  comments << endl << "</p>" << endl << endl;
}

static void HTMLDungeonNPCs(ostream& out,Tcl_Interp *interp,CharacterList *npcs)
{
	if (npcs == NULL) return;
	out << "<h1>Non Playing Characters:</h1><br>" << endl;
	for (CharacterList *ch = npcs; ch != NULL; ch = ch->NextCharacter)
	{
		ch->HTMLPut(out,interp);
	}
}


static void HTMLDungeonMonsters(ostream& out,Tcl_Interp *interp,MonsterList *mons)
{
	if (mons == NULL) return;
	out << "<h1>Monsters:</h1><br>" << endl;
	for (MonsterList *mon = mons; mon != NULL; mon = mon->NextMonster)
	{
		mon->HTMLPut(out,interp);
	}
}


static void HTMLDungeonTricks(ostream& out,Tcl_Interp *interp,TrickList *tricks)
{
	if (tricks == NULL) return;
	out << "<h1>Tricks:</h1><br>" << endl;
	for (TrickList *trick = tricks; trick != NULL; trick = trick->NextTrick)
	{
		trick->HTMLPut(out,interp);
	}
}

static void HTMLDungeonTreasures(ostream& out,Tcl_Interp *interp,TreasureList *treasures)
{
	if (treasures == NULL) return;
	out << "<h1>Treasures:</h1><br>" << endl;
	for (TreasureList *treasure = treasures; treasure != NULL; treasure = treasure->NextTreasure)
	{
		treasure->HTMLPut(out,interp);
	}
}


#include <RPGDict.h>

static void PSDungeonHead(ostream& out,String name,String comments,int l, int xs,int ys)
{
	out << "(Name: " << PSQuote(name) << ") showhead" << endl;
	out << "(" << "Size: " << l
	    << " levels of " << xs << " by " << ys 
	    << " squares" << ") showline" << endl;
	out << "NORMFONT" << endl;
	out << "(" << PSQuoteXnewline(comments) << ") CommentsParagraph" << endl;
}

static void PSDungeonNPCs(ostream& out,Tcl_Interp *interp,CharacterList *npcs)
{
	if (npcs == NULL) return;
	out << "(Non Playing Characters:) showhead" << endl;
	out << "NORMFONT" << endl;
	for (CharacterList *ch = npcs; ch != NULL; ch = ch->NextCharacter)
	{
		ch->PSPut(out,interp);
	}
}

static void PSDungeonMonsters(ostream& out,Tcl_Interp *interp,MonsterList *mons)
{
	if (mons == NULL) return;
	out << "(Monsters:) showhead" << endl;
	out << "NORMFONT" << endl;
	for (MonsterList *mon = mons; mon != NULL; mon = mon->NextMonster)
	{
		mon->PSPut(out,interp);
	}
}

static void PSDungeonTricks(ostream& out,Tcl_Interp *interp,TrickList *tricks)
{
	if (tricks == NULL) return;
	out << "(Tricks:) showhead" << endl;
	out << "NORMFONT" << endl;
	for (TrickList *trick = tricks; trick != NULL; trick = trick->NextTrick)
	{
		trick->PSPut(out,interp);
	}
}

static void PSDungeonTreasures(ostream& out,Tcl_Interp *interp,TreasureList *treasures)
{
	if (treasures == NULL) return;
	out << "(Treasures:) showhead" << endl;
	out << "NORMFONT" << endl;
	for (TreasureList *treasure = treasures; treasure != NULL; treasure = treasure->NextTreasure)
	{
		treasure->PSPut(out,interp);
	}
}

int Dungeon::PrintToFile(Tcl_Interp *interp,char *filename,PrintType typ)
{
	opfstream stream(filename);
	if (!stream) return 0;
	switch (typ)
	{
		case text:
			TxtDungeonHead(stream,Name,Comments,Levels,XSize,YSize);
			TxtDungeonNPCs(stream,interp,NPCList);
			TxtDungeonMonsters(stream,interp,MasterMonsterList);
			TxtDungeonTricks(stream,interp,MasterTrickList);
			TxtDungeonTreasures(stream,interp,MasterTreasureList);
			if (spaces == NULL) break;
			for (int l = 0;l < Levels;l++)
			{
				Space ***level = spaces[l];
				if (level == NULL) continue;
				for (int y = 0;y < YSize;y++)
				{
					Space **row = level[y];
					if (row == NULL) continue;
					for (int x = 0;x < XSize;x++)
					{
						if (row[x] == NULL) continue;
						stream << "Space at level "
						       << l << " (" << x 
						       << "," << y << ")"
						       << endl;
						row[x]->TEXTPut(stream);
					}
				}
			}
			break;
		case html:
			HTMLDungeonHead(stream,Name,Comments,Levels,XSize,YSize);
			HTMLDungeonNPCs(stream,interp,NPCList);
			HTMLDungeonMonsters(stream,interp,MasterMonsterList);
			HTMLDungeonTricks(stream,interp,MasterTrickList);
			HTMLDungeonTreasures(stream,interp,MasterTreasureList);
			if (spaces == NULL) break;
			for (l = 0;l < Levels;l++)
			{
				Space ***level = spaces[l];
				if (level == NULL) continue;
				for (int y = 0;y < YSize;y++)
				{
					Space **row = level[y];
					if (row == NULL) continue;
					for (int x = 0;x < XSize;x++)
					{
						if (row[x] == NULL) continue;
						stream << "<h1>Space at level "
						       << l << " (" << x
						       << "," << y << ")"
						       << "</h1><br>" << endl;
						row[x]->HTMLPut(stream); 
					}
				}
			}
			break;
		case postscript:
			RPGDict(stream,Name);
			PSDungeonHead(stream,Name,Comments,Levels,XSize,YSize);
			PSDungeonNPCs(stream,interp,NPCList);
			PSDungeonMonsters(stream,interp,MasterMonsterList);
			PSDungeonTricks(stream,interp,MasterTrickList);
			PSDungeonTreasures(stream,interp,MasterTreasureList);
			const YsPerPage = 7,
			      XsPerPage = 6;
			if (spaces == NULL) goto psEnd;
			for (l = 0;l < Levels;l++)
			{
				Space ***level = spaces[l];
				if (level == NULL) continue;
				for (int y = 0;y < YSize;y++)
				{
					Space **row = level[y];
					if (row == NULL) continue;
					for (int x = 0;x < XSize;x++)
					{
						if (row[x] == NULL) continue;
						stream << "(Space at level "
						       << l << " \\(" << x
						       << "," << y << "\\)"
						       << ") showhead" << endl;
						row[x]->PSPut(stream);
					}
				}
			}
			for (l = 0;l < Levels;l++)
			{
			  Space ***level = spaces[l];
			  if (level == NULL) continue;
			  stream << "newpage 0 1 inch translate" << endl;
			  for (int yp = 0; yp < YSize; yp += YsPerPage)
			  {
			    for (int xp = 0; xp < XSize; xp += XsPerPage)
			    {
			      int YsThisPage = YsPerPage;
			      if (yp+YsThisPage > YSize) YsThisPage = YSize - yp;
			      int XsThisPage = XsPerPage;
			      if (xp+XsThisPage > XSize) XsThisPage = XSize - xp;
			      stream << "1.5 inch " << YsPerPage + 1.5
				     << " inch moveto BIGFONT (Level: "
				     << l << ") show NORMFONT" << endl;
			      for (int xx = 0; xx < XsThisPage; xx++)
			      {
				stream << xx + .5 << " inch "
				       << YsThisPage + .5 << " inch moveto ("
				       << xx + xp << ") show" << endl;
				stream << xx + .5 << " inch "
				       << "-.5 inch moveto (" << xx + xp 
				       << ") show" << endl;
			      }
			      for (int yy = 0; yy < YsThisPage; yy++)
			      {
				stream << "-.5 inch " << (YsThisPage-yy) - .5
				       << " inch moveto (" << yy + yp 
				       << ") show" << endl;
				stream << XsThisPage + .5 << " inch "
				       << (YsThisPage-yy) - .5 
				       << " inch moveto (" << yy + yp 
				       << ") show" << endl;
			      }
			      for (yy = YsThisPage-1;yy >= 0;yy--)
			      {
			      	Space **row = level[yy+yp];
			      	stream << "gsave" << endl;
			      	for (int xx = 0; xx < XsThisPage; xx++)
			      	{
			      	  stream << "gsave" << endl;
			      	  stream << "0.72 0.72 scale" << endl;
			      	  stream << "newpath 0 0 moveto 0 100 lineto 100 100 lineto 100 0 lineto closepath stroke"
			      	         << endl;
			      	  if (row != NULL)
			      	  {
			      	    Space *sp = row[xx+xp];
			      	    if (sp != NULL) sp->PSPutMap(stream,interp);
			      	  }
			      	  stream << "grestore" << endl;
			      	  stream << "1 inch 0 translate" << endl;
			      	}
			      	stream << "grestore" << endl;
			      	stream << "0 1 inch translate" << endl;
			      }
			    }
			  }
			}
			psEnd:
			stream << "newpage" << endl;
			RPGDictEnd(stream);
			break;
		default:
			break;
	}
	if (!stream) return 0;
	return 1;
}


void_pt DungeonHandles = NULL;

int Dungeon::TclFunction(Tcl_Interp *interp, int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"Dungeon");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Name");
		Tcl_DStringAppendElement(&result,(char*)Name);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Comments");
		Tcl_DStringAppendElement(&result,(char*)Comments);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Levels");
		{
			ostrstream stream;
			stream << Levels;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"XSize");
		{
			ostrstream stream;
			stream << XSize;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"YSize");
		{
			ostrstream stream;
			stream << YSize;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"NPCList");
		if (NPCList == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,CharacterList::Handles,
			    NPCList,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"MasterMonsterList");
		if (MasterMonsterList == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,MonsterList::Handles,
			    MasterMonsterList,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"MasterTrickList");
		if (MasterTrickList == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,TrickList::Handles,
					    MasterTrickList,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"MasterTreasureList");
		if (MasterTreasureList == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,TreasureList::Handles,
					    MasterTreasureList,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "Dungeon", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "write") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," filename\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
		if (!WriteToFile(interp,argv[2]))
		{
			Tcl_AppendResult(interp, "Error writing file ",argv[2],
					 (char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;
	} else if (strcmp(argv[1], "read") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," filename\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
		if (!ReadFromFile(interp,argv[2]))
		{
			Tcl_AppendResult(interp, "Error reading file ",argv[2],
					 (char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;
	} else if (strcmp(argv[1], "print") == 0)
	{
		if (argc < 3 || argc > 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " filename ?mode?\"",(char *) NULL);
			return TCL_ERROR;
		}
		PrintType typ = text;
		if (argc == 4)
		{
			if (strcmp(argv[3],"text") == 0) typ = text;
			else if (strcmp(argv[3],"html") == 0) typ = html;
			else if (strcmp(argv[3],"postscript") == 0)
				typ = postscript;
			else
			{
				Tcl_AppendResult(interp, "wrong print mode: ",
						 argv[3]," should be one of {",
						 "text html html}",
						 (char *) NULL);
				return TCL_ERROR;
			}
		}
		if (!PrintToFile(interp,argv[2],typ))
		{
			Tcl_AppendResult(interp, "Error printing to ",
					 argv[2],(char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;
	} else if (strcmp(argv[1], "name") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Name = argv[2];
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "comments") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Comments,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Comments = argv[2];
			Tcl_AppendResult(interp,(char*)Comments,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "levels") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << Levels;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "xsize") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << XSize;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "ysize") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << YSize;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "space") == 0)
	{
		Space *newsp;
		bool isnew = FALSE;
		int l, x, y;
		if (argc < 5 || argc > 6)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," l x y ",
					 "?spacehandle?\"",(char *) NULL);
			return TCL_ERROR;
		} else if (argc == 6)
		{
			if (argv[5][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
							      Space::Handles,
							      argv[5]);
				if (ptr == NULL) return TCL_ERROR;
				newsp = *((Space**)ptr);
			} else newsp = NULL;
			isnew = TRUE;
		}
		if (Tcl_GetInt(interp,argv[2],&l) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[3],&x) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[4],&y) != TCL_OK)
			return TCL_ERROR;
		if (isnew) (*this)(l,x,y) = newsp;
		newsp = (*this)(l,x,y);
		if (newsp == NULL) interp->result = "";
		else
		{
			char temp[32];
			if (PointerToHandle(interp,Space::Handles,newsp,temp)
				!= TCL_OK)
				return TCL_ERROR;
			Tcl_AppendResult(interp,temp,(char *) NULL);
		}
		return TCL_OK;
	} else if (strcmp(argv[1],"locate") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," spacehandle\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (spaces == NULL)
		{
			Tcl_AppendResult(interp,"",(char *) NULL);
			return TCL_OK;
		}
		void_pt ptr = Tcl_HandleXlate(interp,
					      Space::Handles,
					      argv[2]);
		if (ptr == NULL) return TCL_ERROR;
		Space* sp = *((Space**)ptr);
		for (int l = 0; l < Levels; l++)
		{
			if (spaces[l] == NULL) continue;
			Space ***level = spaces[l];
			for (int y = 0; y < YSize; y++)
			{
				if (level[y] == NULL) continue;
				Space **row = level[y];
				for (int x = 0; x < XSize; x++)
				{
					if (row[x] == sp)
					{
						ostrstream stream;
						stream << l << " " << x << " " << y;
						_IO_ssize_t i = stream.pcount();
						char *s = stream.str();
						s[i] = '\0';
						Tcl_AppendResult(interp,s,(char *) NULL);
						return TCL_OK;
					}
				}
			}
		}
		Tcl_AppendResult(interp,"",(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1],"npclist") == 0)
	{
		if (argc == 3)
		{
			CharacterList* nx = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					CharacterList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((CharacterList**) ptr);
			}
			NPCList = nx;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (NPCList == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,CharacterList::Handles,NPCList,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "mastermonsterlist") == 0)
	{
		if (argc == 3)
		{
			MonsterList* nx = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					MonsterList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((MonsterList**) ptr);
			}
			MasterMonsterList = nx;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (MasterMonsterList == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,MonsterList::Handles,MasterMonsterList,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "mastertricklist") == 0)
	{
		if (argc == 3)
		{
			TrickList* nx = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					TrickList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((TrickList**) ptr);
			}
			MasterTrickList = nx;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (MasterTrickList == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,TrickList::Handles,MasterTrickList,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "mastertreasurelist") == 0)
	{
		if (argc == 3)
		{
			TreasureList* nx = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					TreasureList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((TreasureList**) ptr);
			}
			MasterTreasureList = nx;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (MasterTreasureList == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,TreasureList::Handles,MasterTreasureList,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1],"delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,DungeonHandles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (DungeonHandles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}

static void deleteDungeon(ClientData clientData)
{
	register Dungeon *d = (Dungeon *) clientData;
	delete d;
}

static int dungeonCommand(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	register Dungeon *d = (Dungeon *) clientData;
	return d->TclFunction(interp,argc,argv);
}

static int dungeonCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	Dungeon *d;
	int l, x, y;
	char handle[32];
	
	if (argc != 6)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," name comments levels xsize ysize\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	/* argv[1] : name */
	/* argv[2] : comments */
	if (Tcl_GetInt(interp,argv[3],&l) != TCL_OK)
		return TCL_ERROR;
	if (Tcl_GetInt(interp,argv[4],&x) != TCL_OK)
		return TCL_ERROR;
	if (Tcl_GetInt(interp,argv[5],&y) != TCL_OK)
		return TCL_ERROR;
	d = new Dungeon(argv[1],argv[2],l,x,y);
	Dungeon **h = (Dungeon **) Tcl_HandleAlloc(DungeonHandles,handle);
	*h = d;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)dungeonCommand,
			 (ClientData)d,
			 (Tcl_CmdDeleteProc*)deleteDungeon);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}


int Dungeon_Init(Tcl_Interp *interp)
{
	DungeonHandles = Tcl_HandleTblInit("Dungeon",sizeof(Dungeon*),256);
	Tcl_CreateCommand(interp, "Dungeon", (Tcl_CmdProc*)dungeonCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

int Game::ReadFromFile(Tcl_Interp *interp,char *filename)
{
	int temp;
	ifstream stream(filename);
	if (!stream) return 0;
	stream >> DungeonFile;
	char handle[32];
	Dungeon *newd = new Dungeon("","",0,0,0);
	Dungeon **h = (Dungeon **) Tcl_HandleAlloc(DungeonHandles,handle);
	*h = newd;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)dungeonCommand,
			  (ClientData)newd,
			  (Tcl_CmdDeleteProc*)deleteDungeon);
	DungeonHandle = handle;
	Tcl_HashTable *treasures;
	if (newd->ReadFromFile(interp,(char*)DungeonFile,&treasures) != 1)
		return 0;
	if (!stream) return 0;
	stream >> temp;
	stream.get();
	if (!stream) return 0;
	Notes = "";
	while (temp > 0)
	{
		Notes += stream.get();
		if (!stream) return 0;
		temp--;
	}
	if (!stream) return 0;
	stream >> CurLevel >> CurX >> CurY;
	if (!stream) return 0;
	String oldhandle;
	static char newhandle[32];
	Tcl_HashTable characters;
	Tcl_InitHashTable(&characters,TCL_STRING_KEYS);
	while (stream.get() != '{') ;
	Players = NULL;
	CharacterList **characterslot;
	characterslot = &Players;
	while (stream.peek() != '}')
	{
		//while (stream.peek() == ' ') stream.get();
		int newPtr;
		if (Tcl_VarEval(interp,"CharacterList",(char*) NULL) != TCL_OK)
			return 0;
		char tlhand[32];
		strcpy(tlhand,interp->result);
		CharacterList *newtl;
		CharacterList **tl = (CharacterList **) Tcl_HandleXlate (interp,CharacterList::Handles,tlhand);
		newtl = *tl;
		stream >> *newtl;
		oldhandle = newtl->Handle;
		Tcl_HashEntry *he = Tcl_CreateHashEntry(&characters,
							(char*)oldhandle,
							&newPtr);
		if (newPtr)
		{
			if (Tcl_VarEval(interp,"Character",(char*) NULL) != TCL_OK)
				return 0;
			strcpy(newhandle,interp->result);
			if (Tcl_VarEval(interp,newhandle," read ",(char*)newtl->File,(char*) NULL) != TCL_OK)
				return 0;
			char *newh = new char[strlen(newhandle)+1];
			strcpy(newh,newhandle);
			Tcl_SetHashValue(he,(ClientData)newh);
		} else strcpy(newhandle,(char*)Tcl_GetHashValue(he));
		newtl->Handle = newhandle;
		*characterslot = newtl;
		characterslot = &newtl->NextCharacter;
		FixUpEncumbrenceHandles(newtl->Encumbrences,treasures,interp);
	}
	Tcl_DeleteHashTable(&characters);
	Tcl_DeleteHashTable(treasures);
	newd->treasuresht = FALSE;
	return 1;
}

int Game::WriteToFile(Tcl_Interp *interp,char *filename)
{
	ofstream stream(filename);
	if (!stream) return 0;
	stream << DungeonFile << endl;
	if (!stream) return 0;
	stream << Notes.length() << " " << Notes << endl;
	if (!stream) return 0;
	stream << CurLevel << " " << CurX << " " << CurY << endl;
	if (!stream) return 0;
	stream << "{";
	if (!stream) return 0;
	for (CharacterList *np = Players; np != NULL; np = np->NextCharacter)
	{
		stream << *np;
		if (!stream) return 0;
		if (np->NextCharacter != NULL) stream << " ";
	}
	stream << "}" << endl;
	if (!stream) return 0;
	return 1;
}

static void TxtGameHead(ostream& out,String dungeonFile,String notes,int l,int x,int y)
{
	out << "Dungeon File: " << dungeonFile << endl;
	out << "At Level: " << l << " (" << x << "," << y << ")" << endl;
	out << notes <<endl << endl;
}

static void HTMLGameHead(ostream& out,String dungeonFile,String notes,int l,int x,int y)
{
	out << "<title>Dungeon File: " << dungeonFile << "</title>" << endl;
	out << "<h1>Dungeon File: " << dungeonFile << "</h1>" << endl;
	out << "<h1>At Level: " << l << " (" << x << "," << y << ")</h1>" << endl;
	out << "<p>" << notes << endl << "</p>" << endl << endl;
	
}

static void PSGameHead(ostream& out,String dungeonFile,String notes,int l,int x,int y)
{
	out << "(Dungeon File: " << PSQuote(dungeonFile) << ") showhead" << endl;
	out << "(At Level: " << l << " \\(" << x << "," << y << "\\)) showline" << endl;
	out << "NORMFONT" << endl;
	out << "(" << PSQuoteXnewline(notes) << ") CommentsParagraph" << endl;
}

static void TxtGamePlayers(ostream& out,Tcl_Interp *interp,CharacterList *npcs)
{
	if (npcs == NULL) return;
	out << "Playing Characters:" << endl;
	for (CharacterList *ch = npcs; ch != NULL; ch = ch->NextCharacter)
	{
		ch->TEXTPut(out,interp);
	}
}

static void HTMLGamePlayers(ostream& out,Tcl_Interp *interp,CharacterList *npcs)
{
	if (npcs == NULL) return;
	out << "<h1>Playing Characters:</h1><br>" << endl;
	for (CharacterList *ch = npcs; ch != NULL; ch = ch->NextCharacter)
	{
		ch->HTMLPut(out,interp);
	}
}

static void PSGamePlayers(ostream& out,Tcl_Interp *interp,CharacterList *npcs)
{
	if (npcs == NULL) return;
	out << "(Playing Characters:) showhead" << endl;
	out << "NORMFONT" << endl;
	for (CharacterList *ch = npcs; ch != NULL; ch = ch->NextCharacter)
	{
		ch->PSPut(out,interp);
	}
}

int Game::PrintToFile(Tcl_Interp *interp,char *filename,PrintType typ)
{
	opfstream stream(filename);
	if (!stream) return 0;
	switch (typ)
	{
		case text:
			TxtGameHead(stream,DungeonFile,Notes,CurLevel,CurX,CurY);
			TxtGamePlayers(stream,interp,Players);
			break;
		case html:
			HTMLGameHead(stream,DungeonFile,Notes,CurLevel,CurX,CurY);
			HTMLGamePlayers(stream,interp,Players);
			break;
		case postscript:
			RPGDict(stream,"");
			PSGameHead(stream,DungeonFile,Notes,CurLevel,CurX,CurY);
			PSGamePlayers(stream,interp,Players);
			stream << "newpage" << endl;
			RPGDictEnd(stream);
			break;
		default:
			break;
	}
	if (!stream) return 0;
	return 1;
}

void_pt GameHandles = NULL;

int Game::TclFunction(Tcl_Interp *interp, int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"Game");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"DungeonHandle");
		Tcl_DStringAppendElement(&result,(char*)DungeonHandle);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"DungeonFile");
		Tcl_DStringAppendElement(&result,(char*)DungeonFile);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Notes");
		Tcl_DStringAppendElement(&result,(char*)Notes);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Players");
		if (Players == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,CharacterList::Handles,
				Players,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"CurLevel");
		{
			ostrstream stream;
			stream << CurLevel;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"CurX");
		{
			ostrstream stream;
			stream << CurX;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"CurY");
		{
			ostrstream stream;
			stream << CurY;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "Game", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "write") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," filename\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
		if (!WriteToFile(interp,argv[2]))
		{
			Tcl_AppendResult(interp, "Error writing file ",argv[2],
					 (char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;
	} else if (strcmp(argv[1], "read") == 0)
	{
		if (argc != 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
			 		  argv[0]," ",argv[1]," filename\"",
					  (char *) NULL);
			return TCL_ERROR;
		}
		if (!ReadFromFile(interp,argv[2]))
		{
			Tcl_AppendResult(interp, "Error reading file ",argv[2],
					 (char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;
	} else if (strcmp(argv[1], "print") == 0)
	{
		if (argc < 3 || argc > 4)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],
					 " filename ?mode?\"",(char *) NULL);
			return TCL_ERROR;
		}
		PrintType typ = text;
		if (argc == 4)
		{
			if (strcmp(argv[3],"text") == 0) typ = text;
			else if (strcmp(argv[3],"html") == 0) typ = html;
			else if (strcmp(argv[3],"postscript") == 0)
				typ = postscript;
			else
			{
				Tcl_AppendResult(interp, "wrong print mode: ",
						 argv[3]," should be one of {",
						 "text html html}",
						 (char *) NULL);
				return TCL_ERROR;
			}
		}
		if (!PrintToFile(interp,argv[2],typ))
		{
			Tcl_AppendResult(interp, "Error printing to ",
					 argv[2],(char *) NULL);
			return TCL_ERROR;
		} else return TCL_OK;
	} else if (strcmp(argv[1], "dungeonhandle") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)DungeonHandle,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			DungeonHandle = argv[2];
			Tcl_AppendResult(interp,(char*)DungeonHandle,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "dungeonfile") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)DungeonFile,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			DungeonFile = argv[2];
			Tcl_AppendResult(interp,(char*)DungeonFile,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "notes") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Notes,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Notes = argv[2];
			Tcl_AppendResult(interp,(char*)Notes,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "players") == 0)
	{
		if (argc == 3)
		{
			CharacterList* nx = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					CharacterList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((CharacterList**) ptr);
			}
			Players = nx;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (Players == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,CharacterList::Handles,Players,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "curlevel") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp,argv[2],&CurLevel) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << CurLevel;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "curx") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp,argv[2],&CurX) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << CurX;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "cury") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetInt(interp,argv[2],&CurY) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << CurY;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,GameHandles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (GameHandles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}

static void deleteGame(ClientData clientData)
{
	register Game *g = (Game *) clientData;
	delete g;
}

static int gameCommand(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	register Game *g = (Game *) clientData;
	return g->TclFunction(interp,argc,argv);
}

static int gameCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	Game *g;
	int l, x, y;
	char handle[32];

	if (argc != 7)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," dungeonhandle dungeonfile notes ",
				 "curlevel curx cury\"", (char*) NULL);
		return TCL_ERROR;
	}
	/* argv[1] : dungeonhandle */
	/* argv[2] : dungeonfile */
	/* argv[3] : notes */
	if (Tcl_GetInt(interp,argv[4],&l) != TCL_OK)
		return TCL_ERROR;
	if (Tcl_GetInt(interp,argv[5],&x) != TCL_OK)
		return TCL_ERROR;
	if (Tcl_GetInt(interp,argv[6],&y) != TCL_OK)
		return TCL_ERROR;
	g = new Game(argv[1],argv[2],argv[3],l,x,y);
	Game **h = (Game **)  Tcl_HandleAlloc(GameHandles,handle);
	*h = g;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)gameCommand,
			  (ClientData)g,
			  (Tcl_CmdDeleteProc*)deleteGame);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

int Game_Init(Tcl_Interp *interp)
{
	GameHandles = Tcl_HandleTblInit("Game",sizeof(Game*),256);
	Tcl_CreateCommand(interp, "Game", (Tcl_CmdProc*)gameCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

