/*
 * ------------------------------------------------------------------
 * Monster.h - Monster Class defs
 * Created by Robert Heller on Sat Mar  4 11:04:19 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: Monster.h,v $
 * Revision 1.4  1995/06/18  17:38:55  heller
 * Updated the Postscript code (cleaned it up, added RPGDict, etc.)
 *
 * Revision 1.3  1995/03/24  00:01:34  heller
 * Converted MonsterHandles from static to static member
 *
 * Revision 1.2  1995/03/17  03:15:18  heller
 * Make dam/att and no apearing ranges (low, high)
 *
 * Revision 1.1  1995/03/05  00:59:22  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

#ifndef _MONSTER_H_
#define _MONSTER_H_

#include <tcl.h>
#include <tclExtend.h>
#include <String.h>
#include <iostream.h>

class IntelligenceRating {
private:
	enum {Non, Animal, Semi, Low, Average, Very, Highly,
	      Exceptionally, Genius, SupraGenius, Godlike, Bogus} value;
public:
	IntelligenceRating() {value = Bogus;}
	IntelligenceRating(String v);
	IntelligenceRating(const char* s)
		{IntelligenceRating i = IntelligenceRating(String(s));
		 value = i.value;
		}
	inline operator !() {return (value == Bogus);}
	inline operator const char* ()
	{switch (value)
	  {
	  	case Non: return "Non";
		case Animal: return "Animal";
		case Semi: return "Semi";
		case Low: return "Low";
		case Average: return "Average";
		case Very: return "Very";
		case Highly: return "Highly";
		case Exceptionally: return "Exceptionally";
		case Genius: return "Genius";
		case SupraGenius: return "Supra-Genius";
		case Godlike: return "Godlike";
		case Bogus: return NULL;
	  }
	  return NULL;
	}
	inline friend ostream& operator << (ostream& s,IntelligenceRating& i)
	{
		s << (char*) i;
		return(s);
	}
	inline friend istream& operator >> (istream& s,IntelligenceRating& i)
	{
		String temp;
		s >> temp;
		i = IntelligenceRating(temp);
		return s;
	}
};


class FreqType {
private:
	enum {Unique, VeryRare, Rare, Uncommon, Common, Bogus} value;
public:
	FreqType() {value = Bogus;}
	FreqType(String v);
	FreqType(const char* s)
		{FreqType f = FreqType(String(s));
		 value = f.value;
		}
	inline operator !() {return (value == Bogus);}
	inline operator const char* ()
	{ switch (value)
	  {
	  	case Unique: return "Unique";
	  	case VeryRare: return "VeryRare";
		case Rare: return "Rare";
		case Uncommon: return "Uncommon";
		case Common: return "Common";
		case Bogus: return NULL;
	  }
	  return NULL;
	}
	inline friend ostream& operator << (ostream& s,FreqType &f)
	{
		s << (char*) f;
		return(s);
	}
	inline friend istream& operator >> (istream& s,FreqType &f)
	{
		String temp;
		s >> temp;
		f = FreqType(temp);
		return(s);
	}
};

class Monster {
public:
	enum PrintType {text, html, postscript};
	String Name, Alignment, TreasureType, SpecialAttacks, SpecialDefences,
	       Psionics, Comments;
	static void_pt Handles;
	enum HitType {Points, Dice, Bogus};
	inline friend ostream& operator << (ostream& s,HitType& h)
	{
		if (h == Monster::Points) s << "Points";
		else if (h == Monster::Dice) s << "Dice";
		else s << "Bogus";
		return(s);
	}
	inline friend istream& operator >> (istream& s,HitType& h)
	{
		String temp;
		s >> temp;
		if (temp == "Points") h = Monster::Points;
		else if (temp == "Dice") h = Monster::Dice;
		else h = Monster::Bogus;
		return(s);
	}
private:
	short int hitpoints;
	signed char hdie,ndie,armclass,move,move_fly,move_swim,move_burrow,
		    move_web,percentLair,numatt,magres;
	struct {signed char l,h;} damatt,noapearing;
	IntelligenceRating intelligence;
	FreqType frequency;
	HitType hittype;
	double size;
	inline void _Monster(int hp, int hd, int nd, int ac, int m, int mf,
			     int ms, int mb, int mw, int pl, int na, int daL,
			     int daH, int mr, int noaL, int noaH,
			     IntelligenceRating i, FreqType f,
			     HitType h, double s, String nm, String al, 
			     String tt, String sa, String sd, String ps, 
			     String com)
		{
			hitpoints = hp;
			hdie = hd;
			ndie = nd;
			armclass = ac;
			move = m;
			move_fly = mf;
			move_swim = ms;
			move_burrow = mb;
			move_web = mw;
			percentLair = pl;
			numatt = na;
			damatt.l = daL;
			damatt.h = daH;
			magres = mr;
			noapearing.l = noaL;
			noapearing.h = noaH;
			intelligence = i;
			frequency = f;
			hittype = h;
			size = s;
			Name = nm;
			Alignment = al;
			TreasureType = tt;
			SpecialAttacks = sa;
			SpecialDefences = sd;
			Psionics = ps;
			Comments = com;
		}
public:
	inline int HitPoints() {return hitpoints;}
	inline int HitDieSides() {return hdie;}
	inline int NumHitDice() {return ndie;}
	inline int ArmorClass() {return armclass;}
	inline int LandSpeed() {return move;}
	inline int FlyingSpeed() {return move_fly;}
	inline int SwimingSpeed() {return move_swim;}
	inline int BurrowingSpeed() {return move_burrow;}
	inline int WebSpeed() {return move_web;}
	inline int PercentInLair() {return percentLair;}
	inline int NumberOfAttacks() {return numatt;}
	inline void DamagePerAttacks(int& L,int& H) {L = damatt.l;H = damatt.h;}
	inline int MagicalResistance() {return magres;}
	inline void NumberApearing(int& L,int& H) {L = noapearing.l;H = noapearing.h;}
	inline String Intelligence() {return String((char*) intelligence);}
	inline String Frequency() {return String((char*) frequency);}
	inline String Hittype()
		{if (hittype == Points) return String("HitPoints");
		 else return String("HitDice");
		}
	inline double Size() {return size;}
	Monster()
	{
//			  hp hd nd ac m mf ms mb mw pl na da mr noa i
//			  i                         f                h
//			  s   nm       al       tt       
//			  sa       sd       ps      com
		_Monster( 0, 0, 0, 0, 0,0, 0, 0, 0, 0, 0, 0,0, 0, 0,0,
			  IntelligenceRating("Non"),FreqType("Unique"),Points,
			  0.0,String(),String(),String(),
			  String(),String(),String(),String());
	}
	Monster(int hp,int ac,int m,int mf,int ms,int mb,int mw,int pl,int na,
		int daL,int daH,
		int mr,int noaL,int noaH,IntelligenceRating i, FreqType f, double s,
		String nm, String al, String tt, String sa, String sd,
		String ps, String com)
		{
			_Monster(hp,0,0,ac,m,mf,ms,mb,mw,pl,na,daL,daH,mr,noaL,noaH,i,f,
				 Points,s,nm,al,tt,sa,sd,ps,com);
		}
	 Monster(int hd,int nd,int ac,int m,int mf,int ms,int mb,int mw,int pl,int na,
		 int daL,int daH,int mr,int noaL,int noaH,IntelligenceRating i, FreqType f, 
		 double s, String nm, String al, String tt, String sa, 
		 String sd, String ps, String com)
	 	 {
	 	 	_Monster(0,hd,nd,ac,m,mf,ms,mb,mw,pl,na,daL,daH,mr,noaL,noaH,i,f,Dice,
	 	 		 s,nm,al,tt,sa,sd,ps,com);
	 	 }
	~Monster();
	int ReadFromFile(char *filename);
	int WriteToFile(char *filename);
	int PrintToFile(char *filename,PrintType typ = text);
	int TclFunction(Tcl_Interp *interp,int argc, char *argv[]);
};

extern String& PSQuoteXnewline(String& source);
extern String& PSQuote(String& source);

#endif // _MONSTER_H_

