/*
 * ------------------------------------------------------------------
 * RPGDict.h - Common RolePlaying PS Dictionary
 * Created by Robert Heller on Sat Jun 17 23:55:42 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: RPGDict.h,v $
 * Revision 1.1  1995/06/18  03:56:44  heller
 * Initial revision
 *
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static void RPGDict(ostream& out,String name)
{
	out << "%!PS-Adobe-2.0" << endl;
	out << "%%Title: " << PSQuote(name) << endl;
	out << "%%Creator: " << PSQuote(rcsid) << endl;
	out << "%%EndComments" << endl;
	out << "%%BeginProlog" << endl;
	out << "/RPGDict 100 dict def" << endl;
	out << "/RPGDictLocals 100 dict def" << endl;
	out << "RPGDict begin" << endl;
	out << "/inch {72 mul} def" << endl;
	out << "/TopOfPage 8 inch def" << endl;
	out << "/WidthOfPage 6 inch def" << endl;
	out << "/wordbreak ( ) def" << endl;
	out << "/BIGSIZE 24 def" << endl;
	out << "/H1SIZE 18 def" << endl;
	out << "/NORMSIZE 12 def" << endl;
	out << "/BIGFONT" << endl;
	out << " { RPGDictLocals begin" << endl;
	out << "   /NewCenturySchlbk-Roman findfont BIGSIZE scalefont setfont" << endl;
	out << "   /ypos ypos lineheight BIGSIZE 1.2 mul sub add def" << endl;
	out << "   /lineheight BIGSIZE 1.2 mul def" << endl;
	out << " end } def" << endl;
	out << "/H1FONT" << endl;
	out << " { RPGDictLocals begin" << endl;
	out << "   /Times-Roman findfont H1SIZE scalefont setfont" << endl;
	out << "   /ypos ypos lineheight H1SIZE 1.2 mul sub add def" << endl;
	out << "   /lineheight H1SIZE 1.2 mul def" << endl;
	out << " end} def" << endl;
	out << "/NORMFONT" << endl;
	out << " { RPGDictLocals begin" << endl;
	out << "   /Times-Roman findfont NORMSIZE scalefont setfont" << endl;
	out << "   /ypos ypos lineheight NORMSIZE 1.2 mul sub add def" << endl;
	out << "   /lineheight NORMSIZE 1.2 mul def" << endl;
	out << "   end} def" << endl;
	out << "/BreakIntoLines" << endl;
	out << " { RPGDictLocals begin" << endl;
	out << "   /proc exch def" << endl;
	out << "   /linewidth exch def" << endl;
	out << "   /textstring exch def" << endl;
	out << "   /breakwidth wordbreak stringwidth pop def" << endl;
	out << "   /curwidth 0 def" << endl;
	out << "   /lastwordbreak 0 def" << endl;
	out << "   /startchar 0 def" << endl;
	out << "   /restoftext textstring def" << endl;
	out << "   { restoftext wordbreak search" << endl;
	out << "     {/nextword exch def pop" << endl;
	out << "      /restoftext exch def" << endl;
	out << "      /wordwidth nextword stringwidth pop def" << endl;
	out << "      curwidth wordwidth add linewidth gt" << endl;
	out << "       { textstring startchar" << endl;
	out << "           lastwordbreak startchar sub " << endl;
	out << "           getinterval proc" << endl;
	out << "         /startchar lastwordbreak def" << endl;
	out << "         /curwidth wordwidth breakwidth add def }" << endl;
	out << "       { /curwidth curwidth wordwidth add" << endl;
	out << "           breakwidth add def" << endl;
	out << "       } ifelse" << endl;
	out << "     /lastwordbreak lastwordbreak" << endl;
	out << "      nextword length add 1 add def" << endl;
	out << "     }" << endl;
	out << "     { pop exit }" << endl;
	out << "     ifelse" << endl;
	out << "   } loop" << endl;
	out << "   /lastchar textstring length def" << endl;
	out << "   textstring startchar lastchar startchar  sub" << endl;
	out << "     getinterval proc" << endl;
	out << "   end" << endl;
	out << "   } def" << endl;
	out << "/showhead { H1FONT showline } def" << endl;
	out << "/showline" << endl;
	out << " { RPGDictLocals begin" << endl;
	out << "   xpos ypos moveto show newline" << endl;
	out << "   end } def" << endl;
	out << "/newlineIndent" << endl;
	out << " { RPGDictLocals begin" << endl;
	out << "   newline /xpos exch def" << endl;
	out << "   end } def" << endl;
	out << "/newpage {RPGDictLocals begin" << endl;
	out << "	  showpage 1 inch 1 inch translate /ypos TopOfPage def" << endl;
	out << "          end} def" << endl;
	out << "/newline" << endl;
	out << " { RPGDictLocals begin" << endl;
	out << "   /ypos ypos lineheight sub def" << endl;
	out << "   ypos 0 lt" << endl;
	out << "   {newpage} if" << endl;
	out << "   /xpos 0 def" << endl;
	out << "   end" << endl;
	out << " } def" << endl;
	out << "/CommentsParagraph" << endl;
	out << " { RPGDictLocals begin" << endl;
	out << "   xpos 0 ne {newline} if /xpos 1 inch def" << endl;
	out << "   WidthOfPage 2 inch sub" << endl;
	out << "   {showline /xpos 1 inch def}" << endl;
	out << "   BreakIntoLines" << endl;
	out << "   /xpos 0 def" << endl;
	out << "   end } def" << endl;
	out << "/putstr { RPGDictLocals begin" << endl;
	out << "	  /string exch def" << endl;
	out << "	  /strwid string stringwidth pop def" << endl;
	out << "	  xpos strwid add WidthOfPage gt" << endl;
	out << "	  {newline} if" << endl;
	out << "	  xpos ypos moveto string show" << endl;
	out << "	  /xpos xpos strwid add def" << endl;
	out << "	  end" << endl;
	out << "        } def" << endl;
	out << "/indent { RPGDictLocals begin" << endl;
	out << "	  xpos add /xpos exch def" << endl;
	out << "	  end" << endl;
	out << "        } def" << endl;
	out << "/DoImageMask {4 dict begin" << endl;
	out << "          /invert exch def" << endl;
	out << "          /height exch def" << endl;
	out << "          /width exch def" << endl;
	out << "          /temp width 7 add 8 idiv string def" << endl;
	out << "          gsave" << endl;
	out << "            width height invert matrix" << endl;
	out << "            { currentfile temp readhexstring pop } bind" << endl;
	out << "            imagemask" << endl;
	out << "          grestore" << endl;
	out << "          end } def" << endl;
	out << "/DoImage {4 dict begin" << endl;
	out << "          /depth exch def" << endl;
	out << "          /height exch def" << endl;
	out << "          /width exch def" << endl;
	out << "          /temp width 7 add 8 idiv string def" << endl;
	out << "          gsave" << endl;
	out << "            width height depth matrix" << endl;
	out << "            { currentfile temp readhexstring pop } bind" << endl;
	out << "            image" << endl;
	out << "          grestore" << endl;
	out << "          end } def" << endl;
	out << "RPGDictLocals begin" << endl;
	out << "/xpos 0 def" << endl;
	out << "/ypos TopOfPage def" << endl;
	out << "/lineheight 0 def" << endl;
	out << "NORMFONT" << endl;
	out << "/ypos TopOfPage def" << endl;
	out << "end" << endl;
	out << "%%EndProlog" << endl;
	out << endl << "1 inch 1 inch translate" << endl;
}

static void RPGDictEnd(ostream& out)
{
	out << "%%Trailer" << endl;
	out << "end" << endl;
	out << "%%EOF" << endl;
}


