/*
 * ------------------------------------------------------------------
 * TreasureLists.cc - Code for TreasureLists and Treasures
 * Created by Robert Heller on Sat Jun 17 23:38:43 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: TreasureLists.cc,v $
// Revision 1.3  1995/06/18  06:37:48  heller
// Add Handlize() method
//
// Revision 1.2  1995/06/18  06:00:49  heller
// fix static member decl. problem
//
// Revision 1.1  1995/06/18  03:50:39  heller
// Initial revision
//
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char rcsid[] = "$Id: TreasureLists.cc,v 1.3 1995/06/18 06:37:48 heller Exp $";

#include <iostream.h>
#include <fstream.h>
#include <pfstream.h>
#include <strstream.h>
#include <Master.h>
#include <Monster.h>
#include <Character.h>
#include <tclExtend.h>
#include <tk.h>
#include <tkX.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

ostream& operator << (ostream& os, TreasureList& tl)
{
	os << tl.Name.length() << " " << tl.Name << " ";
	if (tl.Bitmap == "") os << "{}";
	else os << tl.Bitmap;
	os << " ";
	if (tl.Handle == "") os << "{}";
	else os << tl.Handle;
	os << " ";
	os << tl.SpaceX << " " << tl.SpaceY << " " << tl.Value;
}

istream& operator >> (istream& is, TreasureList& tl)
{
	int l;
	is >> l;
	is.get();
	tl.Name = "";
	while (l > 0)
	{
		tl.Name += is.get();
		l--;
	}
	is >> tl.Bitmap;
	if (tl.Bitmap == "{}") tl.Bitmap = "";
	is >> tl.Handle;
	if (tl.Handle == "{}") tl.Handle = "";
	is >> tl.SpaceX >> tl.SpaceY >> tl.Value;
}

void_pt TreasureList::Handles = NULL;

int TreasureList::TclFunction(Tcl_Interp *interp, int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"TreasureList");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Name");
		Tcl_DStringAppendElement(&result,(char*)Name);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Bitmap");
		Tcl_DStringAppendElement(&result,(char*)Bitmap);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Handle");
		Tcl_DStringAppendElement(&result,(char*)Handle);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"NextTreasure");
		if (NextTreasure == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,TreasureList::Handles,
					    NextTreasure,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SpaceX");
		{
			ostrstream stream;
			stream << SpaceX;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SpaceY");
		{
			ostrstream stream;
			stream << SpaceY;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Value");
		{
			ostrstream stream;
			stream << Value;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "TreasureList", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "name") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Name = argv[2];
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "bitmap") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Bitmap,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Bitmap = argv[2];
			Tcl_AppendResult(interp,(char*)Bitmap,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "handle") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Handle,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Handle = argv[2];
			Tcl_AppendResult(interp,(char*)Handle,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "nexttreasure") == 0)
	{
		if (argc == 3)
		{
			TreasureList* nx = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					TreasureList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((TreasureList**) ptr);
			}
			NextTreasure = nx;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (NextTreasure == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,TreasureList::Handles,NextTreasure,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "spacex") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetDouble(interp,argv[2],&SpaceX) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << SpaceX;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "spacey") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetDouble(interp,argv[2],&SpaceY) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << SpaceY;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "value") == 0)
	{
		if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			Value = temp;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << Value;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "list") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendElement(interp,argv[0]);
		for (TreasureList* nx = NextTreasure; nx != NULL;
		     nx = nx->NextTreasure)
		{
			char temp[32];
			if (PointerToHandle(interp,TreasureList::Handles,nx,
					    temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_AppendElement(interp,temp);
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,TreasureList::Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (TreasureList::Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}

static void deleteTreasureList(ClientData clientData)
{
	register TreasureList *cl = (TreasureList*) clientData;
	delete cl;
}

static int treasureListCommand(ClientData clientData, Tcl_Interp *interp,
				int argc, char *argv[])
{
	register TreasureList *cl = (TreasureList*) clientData;
	return cl->TclFunction(interp,argc,argv);
}

static int treasureListCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	TreasureList *cl;
	if (argc != 1 && argc != 8)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?name bitmap handle next x y value?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1)
	{
		cl = new TreasureList;
	} else
	{
		int v;
		double x,y;
		TreasureList *nx;
		/* argv[1] : Name */
		/* argv[2] : Bitmap */
		/* argv[3] : handle */
		/* argv[4] : NextTreasure handle */
		if (argv[4][0] != '\0')
		{
			void_pt ptr = Tcl_HandleXlate(interp,
						      TreasureList::Handles,
						      argv[4]);
			if (ptr == NULL) return TCL_ERROR;
			nx = *((TreasureList**) ptr);
		} else nx = NULL;
		if (Tcl_GetDouble(interp,argv[5],&x) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetDouble(interp,argv[6],&y) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[7],&v) != TCL_OK)
			return TCL_ERROR;
		cl = new TreasureList(argv[1],argv[2],argv[3],nx,x,y,v);
	}
	char handle[32];
	TreasureList **h = (TreasureList **) Tcl_HandleAlloc (TreasureList::Handles,handle);
	*h = cl;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)treasureListCommand,
			  (ClientData)cl,
			  (Tcl_CmdDeleteProc*)deleteTreasureList);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

int TreasureList::Handlize(Tcl_Interp *interp)
{
	char handle[32];
	TreasureList **tl = (TreasureList **)
		Tcl_HandleAlloc (TreasureList::Handles,handle);
	*tl = this;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)treasureListCommand,
			  this,(Tcl_CmdDeleteProc*)deleteTreasureList);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

static int allTreasureLists(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	walk = -1;
	while (Tcl_HandleWalk(TreasureList::Handles,&walk) != NULL)
	{
		char handle[32];
		Tcl_WalkKeyToHandle(TreasureList::Handles,walk,handle);
		Tcl_AppendElement(interp,handle);
	}
	return TCL_OK;

}



int TreasureList_Init(Tcl_Interp *interp)
{
	TreasureList::Handles = Tcl_HandleTblInit("TreasureList",sizeof(TreasureList*),256);
	Tcl_CreateCommand(interp, "TreasureList", (Tcl_CmdProc*)treasureListCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "AllTreasureLists", (Tcl_CmdProc*)allTreasureLists,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

void_pt Treasure::Handles = NULL;

int TreasureList::PSPut(ostream &os)
{
	os << "(" << Name << ") putstr" << endl;
	if (Bitmap != "")
	{
		os << "( {" << Bitmap << "}) showline" << endl;
	} else	os << "newline" << endl;
	if (Handle != "")
	{
		os << "(" << Handle << ") showline" << endl;
	}
	os << "1 inch indent (at \\(" << SpaceX << "," << SpaceY << "\\) "
	   << Value << ") showline" << endl;
	if (!os) return 0;
	else return 1;
}

int TreasureList::PSPut(ostream &os,Tcl_Interp* interp)
{
	os << "(" << Name << ") putstr" << endl;
	if (Bitmap != "")
	{
		os << "( {" << Bitmap << "}) showline" << endl;
	} else	os << "newline" << endl;
	if (Handle != "")
	{
		os << "(" << Handle << ") showline" << endl;
		void_pt ptr = Tcl_HandleXlate(interp,Treasure::Handles,(char*)Handle);
		if (ptr != NULL) 
		{
			Treasure *tr = *((Treasure **)ptr);
			tr->PSPut(os);
		}
	}
	os << "1 inch indent (at \\(" << SpaceX << "," << SpaceY << "\\) "
	   << Value << ") showline" << endl;
	if (!os) return 0;
	else return 1;
}

int TreasureList::HTMLPut(ostream &os)
{
	os << Name;
	if (Bitmap != "")
	{
		os << " {" << Bitmap << "} <br>" << endl;
	} else	os << "<br>" << endl;
	if (Handle != "")
	{
		os << Handle << "<br>" << endl;
	}
	os << "at (" << SpaceX << "," << SpaceY << ") "
	   << Value << "<br>" << endl;
	if (!os) return 0;
	else return 1;
}

int TreasureList::HTMLPut(ostream &os,Tcl_Interp* interp)
{
	os << Name;
	if (Bitmap != "")
	{
		os << " {" << Bitmap << "} <br>" << endl;
	} else	os << "<br>" << endl;
	if (Handle != "")
	{
		os << Handle << "<br>" << endl;
		void_pt ptr = Tcl_HandleXlate(interp,Treasure::Handles,(char*)Handle);
		if (ptr != NULL) 
		{
			Treasure *tr = *((Treasure **)ptr);
			tr->HTMLPut(os);
		}
	}
	os << "at (" << SpaceX << "," << SpaceY << ") "
	   << Value << "<br>" << endl;
	if (!os) return 0;
	else return 1;
}

int TreasureList::TEXTPut(ostream &os)
{
	os << Name;
	if (Bitmap != "")
	{
		os << " {" << Bitmap << "}" << endl;
	} else	os << endl;
	if (Handle != "")
	{
		os << Handle << endl;
	}
	os << "at (" << SpaceX << "," << SpaceY << ") "
	   << Value << endl;
	if (!os) return 0;
	else return 1;
}

int TreasureList::TEXTPut(ostream &os,Tcl_Interp* interp)
{
	os << Name;
	if (Bitmap != "")
	{
		os << " {" << Bitmap << "}" << endl;
	} else	os << endl;
	if (Handle != "")
	{
		os << Handle << endl;
		void_pt ptr = Tcl_HandleXlate(interp,Treasure::Handles,(char*)Handle);
		if (ptr != NULL) 
		{
			Treasure *tr = *((Treasure **)ptr);
			tr->TEXTPut(os);
		}
	}
	os << "at (" << SpaceX << "," << SpaceY << ") "
	   << Value << endl;
	if (!os) return 0;
	else return 1;
}

ostream& operator << (ostream& os, Treasure& tr)
{
	os << tr.Name.length() << " " << tr.Name << " ";
	os << tr.Type.length() << " " << tr.Type << " ";
	os << tr.Description.length() << " " << tr.Description << " ";
	os << tr.ExperiencePointValue << " " << tr.Value << " "
	   << tr.Unique << " " << tr.Taken;
}

istream& operator >> (istream& is, Treasure& tr)
{
	int l;
	is >> l;
	is.get();
	tr.Name = "";
	while (l > 0)
	{
		tr.Name += is.get();
		l--;
	}
	is >> l;
	is.get();
	tr.Type = "";
	while (l > 0)
	{
		tr.Type += is.get();
		l--;
	}
	is >> l;
	is.get();
	tr.Description = "";
	while (l > 0)
	{
		tr.Description += is.get();
		l--;
	}
	is >> tr.ExperiencePointValue >> tr.Value >> tr.Unique >> tr.Taken;
}

int Treasure::TclFunction(Tcl_Interp *interp, int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"Treasure");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Name");
		Tcl_DStringAppendElement(&result,(char*)Name);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Type");
		Tcl_DStringAppendElement(&result,(char*)Type);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Description");
		Tcl_DStringAppendElement(&result,(char*)Description);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"ExperiencePointValue");
		{
			ostrstream stream;
			stream << ExperiencePointValue;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Value");
		{
			ostrstream stream;
			stream << Value;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Unique");
		if (Unique) Tcl_DStringAppendElement(&result,"1");
		else Tcl_DStringAppendElement(&result,"0");
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Taken");
		if (Taken) Tcl_DStringAppendElement(&result,"1");
		else Tcl_DStringAppendElement(&result,"0");
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "Treasure", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "name") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Name = argv[2];
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "treasuretype") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Type,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Type = argv[2];
			Tcl_AppendResult(interp,(char*)Type,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "description") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Description,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Description = argv[2];
			Tcl_AppendResult(interp,(char*)Description,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "experiencepointvalue") == 0)
	{
		if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			ExperiencePointValue = temp;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << ExperiencePointValue;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "value") == 0)
	{
		if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			Value = temp;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << Value;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "unique") == 0)
	{
		if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			if (temp) Unique = TRUE;
			else Unique = FALSE;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (Unique) Tcl_AppendResult(interp,"1",(char *) NULL);
		else Tcl_AppendResult(interp,"0",(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "taken") == 0)
	{
		if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			if (temp) Taken = TRUE;
			else Taken = FALSE;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (Taken) Tcl_AppendResult(interp,"1",(char *) NULL);
		else Tcl_AppendResult(interp,"0",(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,Treasure::Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (Treasure::Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}

static void deleteTreasure(ClientData clientData)
{
	register Treasure *cl = (Treasure*) clientData;
	delete cl;
}

static int treasureCommand(ClientData clientData, Tcl_Interp *interp,
				int argc, char *argv[])
{
	register Treasure *cl = (Treasure*) clientData;
	return cl->TclFunction(interp,argc,argv);
}

static int treasureCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	Treasure *cl;
	if (argc != 1 && argc != 8)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?name type description ",
				 "experiencepointvalue value unique taken?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1)
	{
		cl = new Treasure;
	} else
	{
		int v,e,u,t;
		/* argv[1] : Name */
		/* argv[2] : Type */
		/* argv[3] : Description */
		if (Tcl_GetInt(interp,argv[4],&e) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[5],&v) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[6],&u) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[7],&t) != TCL_OK)
			return TCL_ERROR;
		cl = new Treasure(argv[1],argv[2],argv[3],e,v,((u)?TRUE:FALSE),
				  ((t)?TRUE:FALSE));
	}
	char handle[32];
	Treasure **h = (Treasure **) Tcl_HandleAlloc (Treasure::Handles,handle);
	*h = cl;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)treasureCommand,
			  (ClientData)cl,
			  (Tcl_CmdDeleteProc*)deleteTreasure);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

static int allTreasures(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	walk = -1;
	while (Tcl_HandleWalk(Treasure::Handles,&walk) != NULL)
	{
		char handle[32];
		Tcl_WalkKeyToHandle(Treasure::Handles,walk,handle);
		Tcl_AppendElement(interp,handle);
	}
	return TCL_OK;

}

static int findTreasuresBy(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	enum {name, ttype, description, valueEQ, valueLT, valueGT} field;
	int test;
	Treasure **cp;
	if (argc != 3)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?{name, type description value=value< value>} pattern? \"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (strcmp(argv[1],"name") == 0) field = name;
	else if (strcmp(argv[1],"type") == 0) field = ttype ;
	else if (strcmp(argv[1],"description") == 0) field = description;
	else if (strcmp(argv[1],"value=") == 0) field = valueEQ;
	else if (strcmp(argv[1],"value<") == 0) field = valueLT;
	else if (strcmp(argv[1],"value>") == 0) field = valueGT;
	else
	{
		Tcl_AppendResult(interp, "Bad field name: ",argv[1],
				 "should be one of {name type ",
				 "description value= value< value>}",
				 (char*) NULL);
		 return TCL_ERROR;
	}
	if (field == valueEQ || field == valueLT || field == valueGT)
	{
		if (Tcl_GetInt(interp,argv[2],&test) != TCL_OK)
			return TCL_ERROR;
	}
	walk = -1;
	while ((cp = (Treasure**) Tcl_HandleWalk(Treasure::Handles,&walk)) != NULL)
	{
		Treasure *c = *cp;
		String value;
		int val,ok;
		switch (field)
		{
			case name:	value = c->Name; break;
			case ttype:	value = c->Type; break;
			case description: value = c->Description; break;
			case valueEQ:
			case valueLT:
			case valueGT:	val = c->Value;
		}
		if (field == name || field == ttype || field == description)
		{
			if (Tcl_StringMatch((char*)value,argv[2]))
			{
				char handle[32];
				Tcl_WalkKeyToHandle(Treasure::Handles,walk,handle);
				Tcl_AppendElement(interp,handle);
			}
		} else
		{
			switch (field)
			{
				case valueEQ: ok = val == test; break;
				case valueLT: ok = val < test; break;
				case valueGT: ok = val > test; break;
			}
			if (ok)
			{
				char handle[32];
				Tcl_WalkKeyToHandle(Treasure::Handles,walk,handle);
				Tcl_AppendElement(interp,handle);
			}
		}
	}
	return TCL_OK;
}


int Treasure_Init(Tcl_Interp *interp)
{
	Treasure::Handles = Tcl_HandleTblInit("Treasure",sizeof(Treasure*),256);
	Tcl_CreateCommand(interp, "Treasure", (Tcl_CmdProc*)treasureCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "AllTreasures", (Tcl_CmdProc*)allTreasures,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "FindTreasureBy", (Tcl_CmdProc*)findTreasuresBy,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

int Treasure::PSPut(ostream &os)
{
	os << "(" << PSQuote(Name) << " [" << PSQuote(Type) << "]) showline"
	   << endl;
	os << "(" << PSQuoteXnewline(Description) << ") CommentsParagraph"
	   << endl;
	os << "(Experience points: " << ExperiencePointValue << ", Value: "
	   << Value;
	if (Unique) os << ", Unique";
	if (Taken)  os << ", Taken";
	os << ") showline" << endl;
	if (!os) return 0;
	else return 1;
}

int Treasure::HTMLPut(ostream &os)
{
	os << Name << " [" << Type << "]<br>" << endl;
	os << "<p>" << endl << Description << endl << "</p>" << endl;
	os << "Experience points: " << ExperiencePointValue << ", Value: "
	   << Value;
	if (Unique) os << ", Unique";
	if (Taken)  os << ", Taken";
	os << "<br>" << endl;
	if (!os) return 0;
	else return 1;
}

int Treasure::TEXTPut(ostream &os)
{
	os << Name << " [" << Type << "]" << endl;
	os << Description << endl;
	os << "Experience points: " << ExperiencePointValue << ", Value: "
	   << Value;
	if (Unique) os << ", Unique";
	if (Taken)  os << ", Taken";
	os << endl;
	if (!os) return 0;
	else return 1;
}



