/*
 * ------------------------------------------------------------------
 * TrickLists.cc - Code for TrickLists and Tricks
 * Created by Robert Heller on Sat Jun 17 23:41:24 1995
 * ------------------------------------------------------------------
 * Modification History: $Log: TrickLists.cc,v $
// Revision 1.3  1995/06/18  06:37:48  heller
// Add Handlize() method
//
// Revision 1.2  1995/06/18  06:00:49  heller
// fix static member decl. problem
//
// Revision 1.1  1995/06/18  03:50:39  heller
// Initial revision
//
 * ------------------------------------------------------------------
 * Contents:
 * ------------------------------------------------------------------
 *  
 *     Role Playing Database -- a program for maintaining a database
 *                              for RPG characters and monsters
 *     Copyright (C) 1995  Robert Heller D/B/A Deepwoods Software
 * 			51 Locke Hill Road
 * 			Wendell, MA 01379-9728
 * 
 *     This program is free software; you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation; either version 2 of the License, or
 *     (at your option) any later version.
 * 
 *     This program is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 * 
 *     You should have received a copy of the GNU General Public License
 *     along with this program; if not, write to the Free Software
 *     Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 * 
 *  
 */

static char rcsid[] = "$Id: TrickLists.cc,v 1.3 1995/06/18 06:37:48 heller Exp $";

#include <iostream.h>
#include <fstream.h>
#include <pfstream.h>
#include <strstream.h>
#include <Master.h>
#include <Monster.h>
#include <Character.h>
#include <tclExtend.h>
#include <tk.h>
#include <tkX.h>
#include <stdlib.h>
#include <X11/Xlib.h>
#include <X11/Xutil.h>

ostream& operator << (ostream& os, TrickList& tl)
{
	os << tl.Name.length() << " " << tl.Name << " ";
	if (tl.Bitmap == "") os << "{}";
	else os << tl.Bitmap;
	os << " ";
	if (tl.Handle == "") os << "{}";
	else os << tl.Handle;
	os << " ";
	os << tl.SpaceX << " " << tl.SpaceY << " " << tl.Value << " " << tl.Active;
}

istream& operator >> (istream& is, TrickList& tl)
{
	int l;
	is >> l;
	is.get();
	tl.Name = "";
	while (l > 0)
	{
		tl.Name += is.get();
		l--;
	}
	is >> tl.Bitmap;
	if (tl.Bitmap == "{}") tl.Bitmap = "";
	is >> tl.Handle;
	if (tl.Handle == "{}") tl.Handle = "";
	is >> tl.SpaceX >> tl.SpaceY >> tl.Value >> tl.Active;
}

void_pt TrickList::Handles = NULL;

int TrickList::TclFunction(Tcl_Interp *interp, int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"TrickList");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Name");
		Tcl_DStringAppendElement(&result,(char*)Name);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Bitmap");
		Tcl_DStringAppendElement(&result,(char*)Bitmap);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Handle");
		Tcl_DStringAppendElement(&result,(char*)Handle);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"NextTrick");
		if (NextTrick == NULL)
		{
			Tcl_DStringAppendElement(&result,"");
		} else
		{
			char temp[32];
			if (PointerToHandle(interp,TrickList::Handles,
					    NextTrick,temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_DStringAppendElement(&result,temp);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SpaceX");
		{
			ostrstream stream;
			stream << SpaceX;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"SpaceY");
		{
			ostrstream stream;
			stream << SpaceY;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Value");
		{
			ostrstream stream;
			stream << Value;
			_IO_ssize_t i = stream.pcount();
			char *s = stream.str();
			s[i] = '\0';
			Tcl_DStringAppendElement(&result,s);
			stream.freeze(0);
		}
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Active");
		if (Active) Tcl_DStringAppendElement(&result,"1");
		else Tcl_DStringAppendElement(&result,"0");
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "TrickList", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "name") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Name = argv[2];
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "bitmap") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Bitmap,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Bitmap = argv[2];
			Tcl_AppendResult(interp,(char*)Bitmap,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "handle") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Handle,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Handle = argv[2];
			Tcl_AppendResult(interp,(char*)Handle,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "nexttrick") == 0)
	{
		if (argc == 3)
		{
			TrickList* nx = NULL;
			if (argv[2][0] != '\0')
			{
				void_pt ptr = Tcl_HandleXlate(interp,
					TrickList::Handles,argv[2]);
				if (ptr == NULL) return TCL_ERROR;
				nx = *((TrickList**) ptr);
			}
			NextTrick = nx;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (NextTrick == NULL)
		{
			interp->result = "";
			return TCL_OK;
		}
		char temp[32];
		if (PointerToHandle(interp,TrickList::Handles,NextTrick,
				    temp) != TCL_OK)
			return TCL_ERROR;
		Tcl_AppendResult(interp,temp,(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "spacex") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetDouble(interp,argv[2],&SpaceX) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << SpaceX;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "spacey") == 0)
	{
		if (argc == 3)
		{
			if (Tcl_GetDouble(interp,argv[2],&SpaceY) != TCL_OK)
				return(TCL_ERROR);
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << SpaceY;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "value") == 0)
	{
		if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			Value = temp;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		ostrstream stream;
		stream << Value;
		_IO_ssize_t i = stream.pcount();
		char *s = stream.str();
		s[i] = '\0';
		Tcl_AppendResult(interp,s,(char *) NULL);
		stream.freeze(0);
		return TCL_OK;
	} else if (strcmp(argv[1], "active") == 0)
	{
		if (argc == 3)
		{
			int temp;
			if (Tcl_GetInt(interp,argv[2],&temp) != TCL_OK)
				return(TCL_ERROR);
			if (temp) Active = TRUE;
			else Active = FALSE;
		} else if (argc > 3)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		if (Active) Tcl_AppendResult(interp,"1",(char *) NULL);
		else Tcl_AppendResult(interp,"0",(char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "list") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendElement(interp,argv[0]);
		for (TrickList* nx = NextTrick; nx != NULL;
		     nx = nx->NextTrick)
		{
			char temp[32];
			if (PointerToHandle(interp,TrickList::Handles,nx,
					    temp) != TCL_OK)
				return TCL_ERROR;
			Tcl_AppendElement(interp,temp);
		}
		return TCL_OK;
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,TrickList::Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (TrickList::Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}

static void deleteTrickList(ClientData clientData)
{
	register TrickList *cl = (TrickList*) clientData;
	delete cl;
}

static int trickListCommand(ClientData clientData, Tcl_Interp *interp,
				int argc, char *argv[])
{
	register TrickList *cl = (TrickList*) clientData;
	return cl->TclFunction(interp,argc,argv);
}

static int trickListCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	TrickList *cl;
	if (argc != 1 && argc != 9)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?name bitmap handle next x y value active?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1)
	{
		cl = new TrickList;
	} else
	{
		int v,a;
		double x,y;
		TrickList *nx;
		/* argv[1] : Name */
		/* argv[2] : Bitmap */
		/* argv[3] : Description */
		/* argv[4] : NextTrick handle */
		if (argv[4][0] != '\0')
		{
			void_pt ptr = Tcl_HandleXlate(interp,
						      TrickList::Handles,
						      argv[4]);
			if (ptr == NULL) return TCL_ERROR;
			nx = *((TrickList**) ptr);
		} else nx = NULL;
		if (Tcl_GetDouble(interp,argv[5],&x) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetDouble(interp,argv[6],&y) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[7],&v) != TCL_OK)
			return TCL_ERROR;
		if (Tcl_GetInt(interp,argv[8],&a) != TCL_OK)
			return TCL_ERROR;
		cl = new TrickList(argv[1],argv[2],argv[3],nx,x,y,v,((a)?TRUE:FALSE));
	}
	char handle[32];
	TrickList **h = (TrickList **) Tcl_HandleAlloc (TrickList::Handles,handle);
	*h = cl;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)trickListCommand,
			  (ClientData)cl,
			  (Tcl_CmdDeleteProc*)deleteTrickList);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

int TrickList::Handlize(Tcl_Interp *interp)
{
	char handle[32];
	TrickList **tl = (TrickList **)
		Tcl_HandleAlloc (TrickList::Handles,handle);
	*tl = this;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)trickListCommand,
			  this,(Tcl_CmdDeleteProc*)deleteTrickList);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

static int allTrickLists(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	walk = -1;
	while (Tcl_HandleWalk(TrickList::Handles,&walk) != NULL)
	{
		char handle[32];
		Tcl_WalkKeyToHandle(TrickList::Handles,walk,handle);
		Tcl_AppendElement(interp,handle);
	}
	return TCL_OK;

}



int TrickList_Init(Tcl_Interp *interp)
{
	TrickList::Handles = Tcl_HandleTblInit("TrickList",sizeof(TrickList*),256);
	Tcl_CreateCommand(interp, "TrickList", (Tcl_CmdProc*)trickListCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "AllTrickLists", (Tcl_CmdProc*)allTrickLists,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

void_pt Trick::Handles = NULL;

int TrickList::PSPut(ostream &os)
{
	os << "(" << Name << ") putstr" << endl;
	if (Bitmap != "")
	{
		os << "( {" << Bitmap << "}) showline" << endl;
	} else	os << "newline" << endl;
	if (Handle != "")
	{
		os << "(" << Handle << ") showline" << endl;
	}
	os << "1 inch indent (at \\(" << SpaceX << "," << SpaceY << "\\) "
	   << Value;
	if (Active) os << " Active";
	os << ") showline" << endl;
	if (!os) return 0;
	else return 1;
}

int TrickList::PSPut(ostream &os,Tcl_Interp* interp)
{
	os << "(" << Name << ") putstr" << endl;
	if (Bitmap != "")
	{
		os << "( {" << Bitmap << "}) showline" << endl;
	} else	os << "newline" << endl;
	if (Handle != "")
	{
		os << "(" << Handle << ") showline" << endl;
		void_pt ptr = Tcl_HandleXlate(interp,Trick::Handles,(char*)Handle);
		if (ptr != NULL) 
		{
			Trick *tr = *((Trick **)ptr);
			tr->PSPut(os);
		}
	}
	os << "1 inch indent (at \\(" << SpaceX << "," << SpaceY << "\\) "
	   << Value;
	if (Active) os << " Active";
	os  << ") showline" << endl;
	if (!os) return 0;
	else return 1;
}

int TrickList::HTMLPut(ostream &os)
{
	os << Name;
	if (Bitmap != "")
	{
		os << " {" << Bitmap << "} <br>" << endl;
	} else	os << "<br>" << endl;
	if (Handle != "")
	{
		os << Handle << "<br>" << endl;
	}
	os << "at (" << SpaceX << "," << SpaceY << ") "
	   << Value;
	if (Active) os << " Active";
	os << "<br>" << endl;
	if (!os) return 0;
	else return 1;
}

int TrickList::HTMLPut(ostream &os,Tcl_Interp* interp)
{
	os << Name;
	if (Bitmap != "")
	{
		os << " {" << Bitmap << "} <br>" << endl;
	} else	os << "<br>" << endl;
	if (Handle != "")
	{
		os << Handle << "<br>" << endl;
		void_pt ptr = Tcl_HandleXlate(interp,Trick::Handles,(char*)Handle);
		if (ptr != NULL) 
		{
			Trick *tr = *((Trick **)ptr);
			tr->HTMLPut(os);
		}
	}
	os << "at (" << SpaceX << "," << SpaceY << ") "
	   << Value;
	if (Active) os << " Active";
	os << "<br>" << endl;
	if (!os) return 0;
	else return 1;
}

int TrickList::TEXTPut(ostream &os)
{
	os << Name;
	if (Bitmap != "")
	{
		os << " {" << Bitmap << "}" << endl;
	} else	os << endl;
	if (Handle != "")
	{
		os << Handle << endl;
	}
	os << "at (" << SpaceX << "," << SpaceY << ") "
	   << Value;
	if (Active) os << " Active";
	os << endl;
	if (!os) return 0;
	else return 1;
}

int TrickList::TEXTPut(ostream &os,Tcl_Interp* interp)
{
	os << Name;
	if (Bitmap != "")
	{
		os << " {" << Bitmap << "}" << endl;
	} else	os << endl;
	if (Handle != "")
	{
		os << Handle << endl;
		void_pt ptr = Tcl_HandleXlate(interp,Trick::Handles,(char*)Handle);
		if (ptr != NULL) 
		{
			Trick *tr = *((Trick **)ptr);
			tr->TEXTPut(os);
		}
	}
	os << "at (" << SpaceX << "," << SpaceY << ") "
	   << Value;
	if (Active) os << " Active";
	os << endl;
	if (!os) return 0;
	else return 1;
}


ostream& operator << (ostream& os, Trick& tr)
{
	os << tr.Name.length() << " " << tr.Name << " ";
	os << tr.Type.length() << " " << tr.Type << " ";
	os << tr.Description.length() << " " << tr.Description;
}

istream& operator >> (istream& is, Trick& tr)
{
	int l;
	is >> l;
	is.get();
	tr.Name = "";
	while (l > 0)
	{
		tr.Name += is.get();
		l--;
	}
	is >> l;
	is.get();
	tr.Type = "";
	while (l > 0)
	{
		tr.Type += is.get();
		l--;
	}
	is >> l;
	is.get();
	tr.Description = "";
	while (l > 0)
	{
		tr.Description += is.get();
		l--;
	}
}

int Trick::TclFunction(Tcl_Interp *interp, int argc, char *argv[])
{
	if (argc == 1)
	{
		// no option, echo slots
		Tcl_DString result;
		Tcl_DStringInit(&result);
		Tcl_DStringAppendElement(&result,"Trick");

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Name");
		Tcl_DStringAppendElement(&result,(char*)Name);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Type");
		Tcl_DStringAppendElement(&result,(char*)Type);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringStartSublist(&result);
		Tcl_DStringAppendElement(&result,"Description");
		Tcl_DStringAppendElement(&result,(char*)Description);
		Tcl_DStringEndSublist(&result);

		Tcl_DStringResult(interp,&result);
		return TCL_OK;
	}
	if (strcmp(argv[1], "type") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],(char *) NULL);
			return TCL_ERROR;
		}
		Tcl_AppendResult(interp, "Trick", (char *) NULL);
		return TCL_OK;
	} else if (strcmp(argv[1], "name") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Name = argv[2];
			Tcl_AppendResult(interp,(char*)Name,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "tricktype") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Type,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Type = argv[2];
			Tcl_AppendResult(interp,(char*)Type,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "description") == 0)
	{
		if (argc == 2)
		{
			Tcl_AppendResult(interp,(char*)Description,(char *) NULL);
			return TCL_OK;
		} else if (argc == 3)
		{
			Description = argv[2];
			Tcl_AppendResult(interp,(char*)Description,(char *) NULL);
			return TCL_OK;
		} else
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1]," ?value?\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
	} else if (strcmp(argv[1], "delete") == 0)
	{
		if (argc != 2)
		{
			Tcl_AppendResult(interp, "wrong # args: should be \"",
					 argv[0]," ",argv[1],"\"",
					 (char *) NULL);
			return TCL_ERROR;
		}
		void_pt header = Tcl_HandleXlate (interp,Trick::Handles,argv[0]);
		if (header == NULL) return TCL_ERROR;
		Tcl_HandleFree (Trick::Handles,header);
		return Tcl_DeleteCommand(interp,argv[0]);
	} else
	{
		Tcl_AppendResult(interp, "Bad option: ",argv[1],(char *) NULL);
		return TCL_ERROR;
	}
}

static void deleteTrick(ClientData clientData)
{
	register Trick *cl = (Trick*) clientData;
	delete cl;
}

static int trickCommand(ClientData clientData, Tcl_Interp *interp,
				int argc, char *argv[])
{
	register Trick *cl = (Trick*) clientData;
	return cl->TclFunction(interp,argc,argv);
}

static int trickCreate(ClientData clientData, Tcl_Interp *interp, int argc, char *argv[])
{
	Trick *cl;
	if (argc != 1 && argc != 4)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?name type description?\"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (argc == 1)
	{
		cl = new Trick;
	} else
	{
		/* argv[1] : Name */
		/* argv[2] : Type */
		/* argv[3] : Description */
		cl = new Trick(argv[1],argv[2],argv[3]);
	}
	char handle[32];
	Trick **h = (Trick **) Tcl_HandleAlloc (Trick::Handles,handle);
	*h = cl;
	Tcl_CreateCommand(interp,handle,(Tcl_CmdProc*)trickCommand,
			  (ClientData)cl,
			  (Tcl_CmdDeleteProc*)deleteTrick);
	Tcl_AppendResult(interp,handle,(char *) NULL);
	return TCL_OK;
}

static int allTricks(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	walk = -1;
	while (Tcl_HandleWalk(Trick::Handles,&walk) != NULL)
	{
		char handle[32];
		Tcl_WalkKeyToHandle(Trick::Handles,walk,handle);
		Tcl_AppendElement(interp,handle);
	}
	return TCL_OK;

}

static int findTricksBy(ClientData clientData, Tcl_Interp *interp,int argc, char *argv[])
{
	int walk;
	enum {name, ttype, description} field;
	Trick **cp;
	if (argc != 3)
	{
		Tcl_AppendResult(interp, "Wrong # args: should be \"",
				 argv[0]," ?{name, type description} pattern? \"",
				 (char*) NULL);
		return TCL_ERROR;
	}
	if (strcmp(argv[1],"name") == 0) field = name;
	else if (strcmp(argv[1],"type") == 0) field = ttype ;
	else if (strcmp(argv[1],"description") == 0) field = description;
	else
	{
		Tcl_AppendResult(interp, "Bad field name: ",argv[1],
				 "should be one of {name type description}",
				 (char*) NULL);
		 return TCL_ERROR;
	}
	walk = -1;
	while ((cp = (Trick**) Tcl_HandleWalk(Trick::Handles,&walk)) != NULL)
	{
		Trick *c = *cp;
		String value;
		switch (field)
		{
			case name:	value = c->Name; break;
			case ttype:	value = c->Type; break;
			case description: value = c->Description; break;
		}
		if (Tcl_StringMatch((char*)value,argv[2]))
		{
			char handle[32];
			Tcl_WalkKeyToHandle(Trick::Handles,walk,handle);
			Tcl_AppendElement(interp,handle);
		}
	}
	return TCL_OK;
}


int Trick_Init(Tcl_Interp *interp)
{
	Trick::Handles = Tcl_HandleTblInit("Trick",sizeof(Trick*),256);
	Tcl_CreateCommand(interp, "Trick", (Tcl_CmdProc*)trickCreate,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "AllTricks", (Tcl_CmdProc*)allTricks,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	Tcl_CreateCommand(interp, "FindTrickBy", (Tcl_CmdProc*)findTricksBy,
			  (ClientData) NULL, (Tcl_CmdDeleteProc*) NULL);
	return TCL_OK;
}

int Trick::PSPut(ostream &os)
{
	os << "(" << PSQuote(Name) << " [" << PSQuote(Type) << "]) showline"
	   << endl;
	os << "(" << PSQuoteXnewline(Description) << ") CommentsParagraph"
	   << endl;
	if (!os) return 0;
	else return 1;
}

int Trick::HTMLPut(ostream &os)
{
	os << Name << " [" << Type << "]<br>" << endl;
	os << "<p>" << endl << Description << endl << "</p>" << endl;
	if (!os) return 0;
	else return 1;
}

int Trick::TEXTPut(ostream &os)
{
	os << Name << " [" << Type << "]" << endl;
	os << Description << endl;
	if (!os) return 0;
	else return 1;
}


