/* 
 * tkAppInit.c --
 *
 *	Provides a default version of the Tcl_AppInit procedure for
 *	use in wish and similar Tk-based applications.
 *
 * Copyright (c) 1993 The Regents of the University of California.
 * All rights reserved.
 *
 * Permission is hereby granted, without written agreement and without
 * license or royalty fees, to use, copy, modify, and distribute this
 * software and its documentation for any purpose, provided that the
 * above copyright notice and the following two paragraphs appear in
 * all copies of this software.
 * 
 * IN NO EVENT SHALL THE UNIVERSITY OF CALIFORNIA BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE UNIVERSITY OF
 * CALIFORNIA HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE UNIVERSITY OF CALIFORNIA SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE UNIVERSITY OF CALIFORNIA HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
 */

#ifndef lint
static char rcsid[] = "$Header: /home/heller/Deepwoods/RolePlaying/C++/RCS/tkAppInit.cc,v 1.11 1995/06/17 20:45:15 heller Exp $ SPRITE (Berkeley)";
#endif /* not lint */

#include "tclExtend.h"
#include "tk.h"
#include "tkX.h"



extern int Character_Init(Tcl_Interp *interp);
extern int Dice_Init(Tcl_Interp *interp);
extern int Monster_Init(Tcl_Interp *interp);
extern int CharacterList_Init(Tcl_Interp *interp);
extern int EncumbrenceList_Init(Tcl_Interp *interp);
extern int MonsterList_Init(Tcl_Interp *interp);
extern int DressingList_Init(Tcl_Interp *interp);
extern int TreasureList_Init(Tcl_Interp *interp);
extern int TrickList_Init(Tcl_Interp *interp);
extern int Treasure_Init(Tcl_Interp *interp);
extern int Trick_Init(Tcl_Interp *interp);
extern int Space_Init(Tcl_Interp *interp);
extern int Dungeon_Init(Tcl_Interp *interp);
extern int Game_Init(Tcl_Interp *interp);
extern int Bitmaps_Init(Tcl_Interp *interp);

/*
 *----------------------------------------------------------------------
 *
 * Tcl_AppInit --
 *
 *	This procedure performs application-specific initialization.
 *	Most applications, especially those that incorporate additional
 *	packages, will have their own version of this procedure.
 *
 * Results:
 *	Returns a standard Tcl completion code, and leaves an error
 *	message in interp->result if an error occurs.
 *
 * Side effects:
 *	Depends on the startup script.
 *
 *----------------------------------------------------------------------
 */

int
Tcl_AppInit(Tcl_Interp *interp)
{
    Tk_Window main;

    main = Tk_MainWindow(interp);

    /*
     * Call the init procedures for included packages.  Each call should
     * look like this:
     *
     * if (Mod_Init(interp) == TCL_ERROR) {
     *     return TCL_ERROR;
     * }
     *
     * where "Mod" is the name of the module.
     */

    if (TclX_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }
    if (TkX_Init(interp) == TCL_ERROR) {
	return TCL_ERROR;
    }

    (void) Character_Init(interp);
    (void) Dice_Init(interp);
    (void) Monster_Init(interp);
    (void) CharacterList_Init(interp);
    (void) EncumbrenceList_Init(interp);
    (void) MonsterList_Init(interp);
    (void) DressingList_Init(interp);
    (void) TreasureList_Init(interp);
    (void) TrickList_Init(interp);
    (void) Treasure_Init(interp);
    (void) Trick_Init(interp);
    (void) Space_Init(interp);
    (void) Dungeon_Init(interp);
    (void) Game_Init(interp);
    (void) Bitmaps_Init(interp);
     
    /*
     * Call Tcl_CreateCommand for application-specific commands, if
     * they weren't already created by the init procedures called above.
     */

    /*
     * Specify a user-specific startup file to invoke if the application
     * is run interactively.  Typically the startup file is "~/.apprc"
     * where "app" is the name of the application.  If this line is deleted
     * then no user-specific startup file will be run under any conditions.
     */

    tcl_RcFileName = "~/.wishrc";
    return TCL_OK;
}
