/*
 * Imperium
 *
 * Copyright (C) 1990-93 by David Wright
 *
 * Feel free to modify and use these sources however you wish, so long
 * as you preserve this copyright notice.
 *
 * $Id: feSupp.c,v 3.4.1.1 1993/11/19 06:24:35 davewt Exp $
 *
 * $Log: feSupp.c,v $
 * Revision 3.4.1.1  1993/11/19  06:24:35  davewt
 * patch3: New base revision.
 *
 * Revision 3.4  1993/10/16  05:03:03  davewt
 * New revision.
 *
 * Revision 3.3  1993/10/16  04:35:45  davewt
 * New  release.
 *
 * Revision 3.2  1993/10/07  02:08:34  davewt
 * New branch release.
 *
 * Revision 3.1.1.1  1993/09/07  01:54:10  davewt
 * patch1: First patch to initial version.
 *
 * Revision 1.5  1992/08/20  22:53:39  DaveWT
 * Added new functions.
 *
 * Revision 1.4  1992/07/29  23:27:42  DaveWT
 * Now uses feMode
 *
 * Revision 1.3  1991/09/21  23:32:31  DaveWT
 * Stupid bug fix
 *
 * Revision 1.2  91/09/21  23:30:20  DaveWT
 * Had to include ImpFeMess.h
 * 
 * Revision 1.1  91/09/21  22:59:01  DaveWT
 * Initial revision
 * 
 * 
 */

#include "../config.h"

#include <stdio.h>
#ifdef I_STRING
#include <string.h>
#else
#include <strings.h>
#endif
#include "../Include/Imperium.h"
#include "../Include/Request.h"
#include "../Include/ImpFeMess.h"
#include "Scan.h"
#include "ImpPrivate.h"

static const char rcsid[] = "$Id: feSupp.c,v 3.4.1.1 1993/11/19 06:24:35 davewt Exp $";

void fePlDirty(IMP, ULONG plNum)
{
    if (IS->is_player.p_feMode & FE_WANT_PLAN)
    {
        user(IS, FE_PLDIRTY);
        userX(IS, plNum, 8);
        userNL(IS);
    }
}

void feShDirty(IMP, ULONG shNum)
{
    if (IS->is_player.p_feMode & FE_WANT_SHIP)
    {
        user(IS, FE_SHDIRTY);
        userX(IS, shNum, 8);
        userNL(IS);
    }
}

void fePowerReport(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_MISC)
    {
        user(IS, FE_POWREP);
    }
}

void feIteCen(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_PLAN)
    {
        user(IS, FE_PLITE);
    }
}

void feProCen(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_PLAN)
    {
        user(IS, FE_PLPRO);
    }
}

void feGeoCen(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_PLAN)
    {
        user(IS, FE_PLGEO);
    }
}

void fePopCen(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_PLAN)
    {
        user(IS, FE_PLPOP);
    }
}

void feBigCen(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_PLAN)
    {
        user(IS, FE_PLBIG);
    }
}

void feCheckReq(IMP, ULONG plNum)
{
    if (IS->is_player.p_feMode & FE_WANT_MISC)
    {
        user(IS, FE_CHREQ);
        userX(IS, plNum, 8);
        userNL(IS);
    }
}

void feShBig(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_SHIP)
    {
        user(IS, FE_SHBIG);
    }
}

void feShStat(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_SHIP)
    {
        user(IS, FE_SHSTAT);
    }
}

void feShCargo(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_SHIP)
    {
        user(IS, FE_SHCARGO);
    }
}

void feRaceRep(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_MISC)
    {
        user(IS, FE_RACEREP);
    }
}

void fePlayStat(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_MISC)
    {
        user(IS, FE_PLAYSTAT);
    }
}

void fePlayList(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_MISC)
    {
        user(IS, FE_PLAYLIST);
    }
}

void fePrintRealm(IMP)
{
    if (IS->is_player.p_feMode & FE_WANT_MISC)
    {
        user(IS, FE_PRINTREALM);
    }
}

