/***********************************************************
*                      K O U L E S                         *
*----------------------------------------------------------*
*  C1995 JAHUSOFT                                          *
*        Jan Hubicka                                       *
*        Dukelskych Bojovniku 1944                         *
*        390 03 Tabor                                      *
*        Czech Republic                                    *
*        Telefon: (048-I think) (0361) 32613               *
*        eMail: hubicka@limax.paru.cas.cz                  *
*----------------------------------------------------------*
* Copyright(c)1995 by Jan Hubicka.See README for license   *
*                          details.                        *
*----------------------------------------------------------*
*  init.c jlib depended initialization routines            *
***********************************************************/
#define PLAYFORM_VARIABLES_HERE
#include <vga.h>
#include <vgagl.h>
GraphicsContext *physicalscreen, *backscreen, *starbackground, *background;
void           *fontblack;
void           *fontwhite;

int             VGAMODE = G640x480x256;

int             GAMEWIDTH = 640;
int             GAMEHEIGHT = 460;
int             MAPWIDTH = 640;
int             MAPHEIGHT = 460;
int             DIV = 1;


#include "../koules.h"
#include "../framebuffer.h"
#include <alloca.h>
#include <sys/time.h>
#include <unistd.h>
#include <asm/io.h>		/*for waiting for retrace */
extern void     fadein1 ();
extern char    *bball_bitmap;
extern char    *apple_bitmap;
extern char    *inspector_bitmap;
extern char    *mouse_bitmap;
extern char    *lball_bitmap[2];
extern char    *circle_bitmap;
extern char    *hole_bitmap;
extern char    *ehole_bitmap;
extern char    *ball_bitmap;
extern char    *eye_bitmap[MAXROCKETS];
extern char    *rocket_bitmap[MAXROCKETS];
extern GraphicsContext *starbackground;
extern void     points ();
extern void     points1 ();
char            hole_data[HOLE_RADIUS * 2][HOLE_RADIUS * 2];
char            ehole_data[HOLE_RADIUS * 2][HOLE_RADIUS * 2];
extern char     rocketcolor[5];
extern void     setcustompalette (int, float);
extern void     starwars ();
extern void     game ();


#define NCOLORS 32

#define HOLE_XCENTER (2*HOLE_RADIUS-3*HOLE_RADIUS/4)
#define HOLE_YCENTER (2*HOLE_RADIUS-HOLE_RADIUS/4)
#define HOLE_MAX_RADIUS (HOLE_RADIUS/DIV+0.5*HOLE_RADIUS/DIV)
#define HOLE_SIZE_MAX (radius*radius)



static void
initialize ()
{
#ifdef SOUND
  printf ("Initializing sound server...\n");
  if (sndinit)
    init_sound ();
#else
  printf ("Sound driver not avaiable-recompile koules with SOUND enabled\n");
#endif

  printf ("Autoprobing hardware\n");
  printf ("Initializing joystick driver\n");
#ifdef JOYSTICK
  joystickdevice[0] = open ("/dev/js0", O_RDONLY);
  if (joystickdevice[0] < 0)
    {
      perror ("Joystick driver");
      printf ("Joystick 1 not avaiable..\n");
      joystickplayer[0] = -1;
    }
  else
    printf ("Joystick 1 initialized\n");
  joystickdevice[1] = open ("/dev/js1", O_RDONLY);
  if (joystickdevice[1] < 0)
    {
      perror ("Joystick driver");
      printf ("Joystick 2 not avaiable..\n");
      joystickplayer[1] = -1;
    }
  else
    printf ("Joystick 2 initialized\n");

#else
  printf ("Joystick driver not avaiable(recompile koules with JOYSTICK enabled )\n");
#endif
  printf ("Initializing mouse server\n");
#ifdef MOUSE
  if (!nomouse)
    vga_setmousesupport (1);
#endif
  printf ("Initializing graphics server\n");
  vga_init ();
  if(!vga_hasmode(VGAMODE)) {
	printf("graphics mode unavaiable(reconfigure svgalib)\n");
        if(VGAMODE==G640x480x256)
	  printf("or use -s option\n");
	exit(-2);
  }
  vga_setmode (VGAMODE);



  printf ("Initializing video memory\n");
  setcustompalette (0, 1);
  gl_setcontextvga (VGAMODE);


  physicalscreen = gl_allocatecontext ();
  gl_getcontext (physicalscreen);


  printf ("Initializing graphics font\n");
  fontblack = malloc (256 * 8 * 8);
  gl_expandfont (8, 8, back (3), gl_font8x8, fontblack);
  fontwhite = malloc (256 * 8 * 8);
  gl_setfont (8, 8, fontwhite);
  gl_expandfont (8, 8, 255, gl_font8x8, fontwhite);


  gl_write (0, 0, "Graphics daemons fired up");
  gl_write (0, 8, "Checking system consitency....virus not found..");
  gl_setcontextvgavirtual (VGAMODE);
  backscreen = gl_allocatecontext ();
  gl_getcontext (backscreen);
  gl_setcontext (physicalscreen);
  gl_write (0, 16, "Calibrating delay loop");


  gl_setcontextvgavirtual (VGAMODE);
  background = gl_allocatecontext ();
  gl_getcontext (background);
  gl_setcontextvgavirtual (VGAMODE);
  starbackground = gl_allocatecontext ();
  gl_getcontext (starbackground);
  gl_setcontext (physicalscreen);


  gl_write (0, 24, "Initializing keyboard daemons");
  if (keyboard_init ())
    {
      printf ("Could not initialize keyboard.\n");
      exit (-1);
    }
  /*keyboard_translatekeys(TRANSLATE_CURSORKEYS | TRANSLATE_KEYPADENTER); */
  keyboard_translatekeys (0);
  gl_write (0, 32, "1 pc capable keyboard found");
}








void
uninitialize ()
{
  int             h, i;
  float           p = 0;
  char            bitmap1[MAPWIDTH][MAPHEIGHT + 20];
  char            bitmap2[MAPWIDTH][MAPHEIGHT + 20];
  gl_enableclipping ();
  gl_setcontext (physicalscreen);
  gl_getbox (0, 0, MAPWIDTH, MAPHEIGHT + 20, bitmap1);
  for (h = (MAPHEIGHT + 20) / 2 - (MAPHEIGHT + 18) / 16; h >= 2; h -= (MAPHEIGHT + 18) / 16)
    {
      p += 64.0 / 8;
      gl_scalebox (MAPWIDTH, MAPHEIGHT + 20, bitmap1,
		   MAPWIDTH, h * 2, bitmap2);
      gl_putbox (0, (MAPHEIGHT + 20) / 2 - h, MAPWIDTH, h * 2, bitmap2);
      gl_fillbox (0, (MAPHEIGHT + 20) / 2 - h - (MAPHEIGHT + 20) / 16, MAPWIDTH, (MAPHEIGHT + 20) / 16, 0);
      gl_fillbox (0, (MAPHEIGHT + 20) / 2 + h, MAPWIDTH, (MAPHEIGHT + 20) / 16, 0);
      setcustompalette ((int) p, 1);
    }
  gl_fillbox (0, (MAPHEIGHT + 20) / 2 - 50 - 2 / DIV, MAPWIDTH, 50, 0);
  gl_fillbox (0, (MAPHEIGHT + 20) / 2 + 2 / DIV, MAPWIDTH, 50, 0);
  for (i = MAPWIDTH / 2; i >= 5; i -= 5 / DIV)
    gl_fillbox (0, (MAPHEIGHT + 20) / 2 - 2, MAPWIDTH / 2 - i, 20, 0),
      gl_fillbox (MAPWIDTH / 2 + i, (MAPHEIGHT + 20) / 2 - 2, MAPWIDTH / 2 - i, 20, 0),
      usleep (500);
  keyboard_close ();
  vga_setmode (TEXT);
#ifdef SOUND
  if (sndinit)
    kill_sound ();
#endif
  printf ("Life support systems disconected\n"
	  "\n\nHave a nice LINUX!\n");
}







int
main (int argc, char **argv)
{
  char            c;
  nrockets = 1;
  printf ("\n\n\n\n"
	  "                                The  game\n"
	  "                               K O U L E S\n"
	  "                               For svgalib\n"
	  "\n\n\n\n"
	  "                       Copyright(c) Jan Hubicka 1995\n\n\n");
  while ((c = getopt (argc, argv, "slxMmdh")) != EOF)
    {
      switch (c)
	{
	case 's':
	  VGAMODE = G320x200x256;
	  GAMEWIDTH = 640;
	  GAMEHEIGHT = 360;
	  MAPWIDTH = 320;
	  MAPHEIGHT = 180;
	  DIV = 2;
	  break;
	case 'l':
	  VGAMODE = G640x480x256;
	  GAMEWIDTH = 640;
	  GAMEHEIGHT = 460;
	  MAPWIDTH = 640;
	  MAPHEIGHT = 460;
	  DIV = 1;
	  break;
	case 'x':
	  /*VGAMODE = G320x240x256;
	  GAMEWIDTH = 640;
	  GAMEHEIGHT = 440;
	  MAPWIDTH = 320;
	  MAPHEIGHT = 220;*/
	  VGAMODE = G360x480x256;
	  GAMEWIDTH = 360;
	  GAMEHEIGHT = 440;
	  MAPWIDTH = 360;
	  MAPHEIGHT = 440;
	  DIV = 0;
	  break;
#ifdef MOUSE
	case 'M':
	  if (mouseplayer == 0)
	    {
	      printf ("-M and -m conflict\n");
	      exit (1);
	    }
	  nomouse = 1;
	  drawpointer = 0;
	  break;
	case 'm':
	  if (nomouse)
	    {
	      printf ("-M and -m conflict\n");
	      exit (1);
	    }
	  mouseplayer = 0;
	  break;
#endif
#ifdef SOUND
	case 'd':
	  sndinit = 0;
	  break;
#endif
	default:
	  printf ("USAGE:\n"
		  " -h for help\n"
		  " -s for small display(320x200)\n"
		  " -l for large display(640x480)\n"
#ifdef SOUND
		  " -d Disable sound support\n"
#endif
#ifdef MOUSE
		  " -m use mouse to control player\n"
		  " -M disable mouse support\n"
#endif
	    );
	  exit (2);
	}
    }

  printf ("LINUX4GW 1.12.45b professional\n");
  printf ("Copyright(c)1991,1992,1993,1994,1995 Jan Hubicka(JAHUSOFT)\n");
  create_bitmap ();
  initialize ();
  gl_write (0, 40, "Initializing GUI user interface");
#ifdef SOUND
  sound = sndinit;
#endif
  init_menu ();
  gamemode = MENU;
  gl_write (0, 48, "Initializing 4d rotation tables");
  init_objects ();
  printf ("creating bitmaps\n");
  gl_write (0, 56, "Initializing refresh daemon ");
  gl_write (0, 66, "please wait 12043.21 Bogomipseconds");
  drawbackground ();
  drawstarbackground ();
  gl_setfont (8, 8, fontblack);

  keys[0][0] = SCANCODE_CURSORBLOCKUP;
  keys[0][1] = SCANCODE_CURSORBLOCKDOWN;
  keys[0][2] = SCANCODE_CURSORBLOCKLEFT;
  keys[0][3] = SCANCODE_CURSORBLOCKRIGHT;

  keys[1][0] = SCANCODE_CURSORUP;
  keys[1][1] = SCANCODE_CURSORDOWN;
  keys[1][2] = SCANCODE_CURSORLEFT;
  keys[1][3] = SCANCODE_CURSORRIGHT;
  starwars ();



  game ();
  printf ("uninitializing\n");
  uninitialize ();
  return 0;
}
