#define __RAWKS_SFX__
#define DBG 0

#include "defines.h"
#include "gl.h"
#include "protos.h"
#include "globals.h"

extern int sound_enabled;
extern int has_sound_hw;

void kill_all_sound(void)
{
  int i;

  Kill_all_sounds = 1;
}

void sfx_kill(int sound)
{
#ifndef NO_SOUND
  int i;

  if(Opts.nosound) return;

  if(End_sound == -1) End_sound = sound;
#endif
}

void sfx(int sound)
{
#ifndef NO_SOUND
  int i;

  if(Opts.nosound || sound < 0 || sound >= SFX_N_SOUNDS) return;

  for(i=0;i<START_SND_QUEUESIZE;i++) {
    if(Start_sound[i] == -1) {
      Start_sound[i] = sound;
      break;
    }
  }
#endif
}

void end_sound(void)
{
#ifndef NO_SOUND
  if(Opts.nosound || !Snd_inited) return;

  snd_end_sound();
#endif
}

void set_volume(int level)
{
#ifndef NO_SOUND
  if(Opts.nosound) return;

  snd_set_volume(level);
#endif
}

void init_sound(void)
{
#ifndef NO_SOUND
  int dm;
  static int soundfont = -1;

  if(Opts.nosound) return;

  dm = getdrawmode();
  ortho2(-1,1,-1,1);
  if(soundfont<0) soundfont = openvecfont(50,30,0.7);
  drawmode(PUPDRAW);
  clear_overlay();
  mapcolor(1,0x77,0x77,0xff); /* Light blue */
  mapcolor(2,0x00,0x00,0x33); /* Dark blue */
  gflush();
  vmov2(soundfont,0.0,0.0);
  vccprint(soundfont,PUPDRAW,2,1,"Loading sounds from disk..please wait");
  snd_init_sound();
  Snd_inited = 1;
  clear_overlay();
  drawmode(dm);
#endif
}

void toggle_sound(void)
{
#ifndef NO_SOUND
  if(Opts.nosound) return;

  snd_toggle_sound();
#endif
}

int volume_change(int direction)
{
#ifndef NO_SOUND
  if(Opts.nosound) return;

  return snd_volume_change(direction);
#else
  return 0;
#endif
}
