/*	Copyright Alex Hornby 1994/1995. All rights reserved.
 	See file README for details
*/

#include "animation.h"
extern "C" {
#include <assert.h>
}

slotElt Animation :: sprbank[MAXFRAME];

struct animElt animElt(int s, int d)
{
	struct animElt r;
	r.slot=s;
	r.duration=d;
	return r;
}

animList operator+( struct animElt a, struct animElt b)
{
	animList l;
	l.append(a); l.append(b);
	return l;
}

animList operator+(animList l, struct animElt a)
{
	l.append(a);
	return l;
}

Animation::Animation()
{
	animflag=false;
}

Animation::Animation( const Animation& a)
{
	setSlot(a.curslot);
	anim=a.anim;
	curframe=0;
	setAnim(a.getAnim());
}

Animation&
Animation::operator=( const Animation& a)
{
	if( &a == this)
		return *this;

	setSlot(a.curslot);
	anim=a.anim;
	curframe=0;
	setAnim(a.getAnim());
	return *this;
}

void
Animation :: setAnim( bool v )
{
	if( v==true)
	{
		curframe=anim.first();
		animflag=true;
		framecounter=0;
	}
	else
	{
		curframe=0;
		animflag=false;
	}
}

void
Animation :: loadFilm( animList a)
{
	anim=a;
	curframe=anim.first();
}

void
Animation :: doAnim( void )
{

	assert(curframe!=0);
	if(framecounter< anim(curframe).duration)
	{
		setSlot(anim(curframe).slot);
		framecounter++;
	}
	else
	{
		framecounter=0;
		anim.next(curframe);
		if(curframe==0)
			setAnim(false);
		else 
		{
			switch( anim(curframe).slot)
			{
			case LOOPANIM:
				setAnim(true);
				break;
			case VANISHANIM:
				setVisible(false);
				setAnim(false);
				break;
			default:
				setSlot(anim(curframe).slot);
			}
		}
	}
}

void 
Animation :: setSlot(int slot)
{
	assert(slot<MAXFRAME);
	assert(slot>=0);
	curslot=slot;
}
