/*	Copyright Alex Hornby 1994/1995. All rights reserved.
 	See file README for details
*/

/* C++ code for block copy wrapper */

#include "screen.h"
#include "asmblock.h"
#include "block.h"
#include <string.h>

#include "btypes.h"

Block::Block() : Screen()
{
	blockmem=0;
}

Block::Block(const Block& b) : Screen(b)
{
	copy(b);
}

Block::~Block()
{
	if(blockmem!=0)
		delete [] blockmem;
}

Block&
Block::operator=(const Block& b)
{
	if(&b!=this)
	{
		Screen::operator=(b);
		copy(b);
	}
	return *this;
}

void
Block::copy(const Block& b)
{
	width=b.width;
	height=b.height;
	byteLength=b.byteLength;
	if(blockmem!=0)
		delete [] blockmem;
	if(b.blockmem!=0)
	{
		blockmem= new byte [byteLength];
		memcpy(blockmem, b.blockmem, byteLength);
	}
}

void 
Block :: cut ( uint32 x1, uint32 y1, uint32 xw, uint32 yw)
{
	width=xw;
	height=yw;

	/* if memory in use then free it */
	if( blockmem!=0 ) delete blockmem; 

	/* reserve block memory */
	byteLength=xw*yw;
	blockmem=new byte [byteLength];

	/* call assembly routine */
	cutblock( getGraphMem()+x1+(y1*getScreenWidth()), blockmem, width, height); 
}

void
Block :: reCut( uint32 x1, uint32 y1)
{
	/* call assembly routine */
	cutblock( getGraphMem()+x1+(y1*getScreenWidth()), blockmem, width, height); 
}

void
Block :: paste( uint32 x1, uint32 y1)
{
	/* Straight into the assembly bit */
	pasteblock( blockmem, getGraphMem()+x1+(y1*getScreenWidth()), width, height );
}
