/* C++ wrapper for assembler block copy routines */

#ifndef BLOCK_H
#define BLOCK_H

extern "C"{
#include "btypes.h"
}

/* needs screen.h */

class
Block : public Screen
{
private:
	void copy(const Block& b);
protected:
	byte *blockmem;
	uint32 width,height,byteLength;
public:
	Block();
	Block(const Block& b);
	Block& operator=(const Block& b);
	virtual ~Block();
	
	virtual void cut(uint32 x1, uint32 y1, uint32 xw, uint32 yw);
	virtual void reCut(uint32 x1, uint32 y1);
	virtual void paste(uint32 x1, uint32 y1);
        int getHeight(void) const { return height;}
        int getWidth(void) const { return width;}
};

#endif
