////////////////////////////////////////////////////////////////////////////
// Displays the vscreen to the crt, in a separate file to allow possible
// X windows port!
////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
// Linux SVGAlib displayer
////////////////////////////////////////////////////////////////////////////
#include <vga.h>
#include "btypes.h"
#include "palette.h"
extern "C" {
#include "gamelib.h"
}

void
display(byte *vscreen)
{
#ifdef FAST
	waitvbl();
#endif
	screencopy( vscreen, graph_mem);
}

void
use_palette(Palette& p)
{
	int r,g,b;
	for(int i=0;i<256;i++)
	{
		if(p.getAlloc(i))
		{
			p.getData(i,r,g,b);
			vga_setpalette(i,r,g,b);
		}
	}
}
