/*	Copyright Alex Hornby 1994/1995. All rights reserved.
 	See file README for details
*/
#include "btypes.h"
#include "palette.h"
#include "gif.h"
#include "asmblock.h"
#include "screendefs.h"
#include "alopen.h"
#include <stdio.h>

byte *fontptr;

void
fcutblock( void* source, void* dest, unsigned int adj, unsigned int width, unsigned int height)
{
        for(int y=0; y<height; y++)
        {
                for(int x=0; x<width ;x++)
                        *( ((byte*)dest)++ )=*( ((byte*)source)++ );
                (byte*)source+=adj;
        }
}
 

void fontinit(void)
{
	byte	*t, *p;
	Gif gif;
	int w;
	FILE* fp=alopen("gfx/font.gif","rb");
	gif.Load(fp);

	t = fontptr = new byte [8192]; // reserve 8k
	w=gif.getWidth();
	p=gif.getPtr();
        int adj=w-8;

	for(int c=0; c<31; c++)
		fcutblock(p,t+=64,adj,8,8);

	for(int r=0;r<3;r++)
	{
 		for(c=0; c<32; c++)
			fcutblock(p+ (r*w*8) + c * 8, 
					t+=64, adj, 8, 8);
	}
}

void printor(char *s, void *dest, int x , int y)
{
	int c=0;
	while( *s != 0 )
	{
		orpasteblock(fontptr+64*(*s), ((byte*)dest)+c*8+x+y*SCREENWIDTH, 8, 8);  
		s++;
		c++;
	}  
}

void print(char *s, void *dest, int x , int y)
{
	int c=0;
	while( *s != 0 )
	{
		pasteblock(fontptr+64*(*s), ((byte*)dest)+c*8+x+y*SCREENWIDTH, 8, 8);  
		s++;
		c++;
	}  
}
