/*	Copyright Alex Hornby 1994/1995. All rights reserved.
 	See file README for details
*/

#include "sprite.h"
#include "soul.h"
#include "entity.h"
#include "weapon.h"
#include "control.h"
#include "slots.h"
#include "player.h"

#include <assert.h>
#include <unistd.h>
#include <vga.h>
#include <vgakeyboard.h>

Player :: Player() : Entity(NUMLIVES,100,100)
{
	dir=STRAIGHT;
	init();
}

Player :: Player( const Player& p) : Entity(p)
{
	dir=p.dir;
	init();
}

Player& 
Player :: operator=(const Player& p)
{
	Entity::operator=(p);
	return *this;
}

void
Player :: init(void)
{
	/* Set up the animations */
	animExp=animElt(EXPLODESLOT,3)+ animElt(EXPLODESLOT+1,3)+
		animElt(EXPLODESLOT+2,1)+animElt(SHIPSLOT,1);
        animLeft=animElt(SHIPSLOT+2,5)+animElt(SHIPSLOT+3,5)+
		animElt(LOOPANIM,0);
        animRight=animElt(SHIPSLOT+4,5)+animElt(SHIPSLOT+5,5)+
		animElt(LOOPANIM,0);
        animStr=animElt(SHIPSLOT,5)+animElt(SHIPSLOT+1,5)+
		animElt(LOOPANIM,0);

	/* We have selected no controller yet */
	controller=0;
	for(int i=0;i<=STARBOARD;i++)
		weapon[i]=0;
}

void
Player :: setControl( Control* c)
{
	controller=c;
}

void
Player :: setWeapon( Weapon* w, rail r)
{
	weapon[r]=w;
}

void
Player :: explode()
{
	loadFilm(animExp);
	setAnim(true);
}

void
Player :: fire()
{
	for(int i=0;i<4;i++)
	{
		if(weapon[i]!=0)
			{
			weapon[i]->fire();
			}
	}
}

bool
Player :: hit( const Sprite& e)
{
	for(int i=0;i<4;i++)
	{
		if(weapon[i]!=0 && weapon[i]->collide(e))
			return true;
	}
	return false;
}

void
Player :: moveWeapons(void)
{	
	for(int i=0;i<4;i++)
	{
		if(weapon[i]!=0)
			weapon[i]->move();
	}
}

void
Player :: control(void)
{
	assert(controller!=0);

	/* Read controller */
	controller->fetch();
	
	if(dir==UP && getAnim()==true)
		return ;

	/* Act on the data read */
	if( controller->test(RIGHT) ) 
	{
		move(1,0);
		if(getDir()!=RIGHT)
		{
			setAnim(true);
			loadFilm(animRight);
			setDir(RIGHT);
		}
	}	

	else if( controller->test(LEFT) ) 
	{
		move(-1,0); 
		if(getDir()!=LEFT)
		{
			setAnim(true);
			loadFilm(animLeft);
			setDir(LEFT);
		}
	}	
	else if (getDir()!=STRAIGHT)
	{
		setAnim(true);
		loadFilm(animStr);
		setDir(STRAIGHT);
	}

	if( controller->test(FIRE1) ) fire();
	if( controller->test(QUIT) ) setLives(0);
	if( controller->test(PAUSE) ) 
	{
		if(controller->getRaw())
			keyboard_close();
		while(vga_getkey()!='p')
			usleep(10000);
		if(controller->getRaw())
			keyboard_init();
	}
	/* Keep object on screen */
	if(xp>getScreenWidth()-getWidth()) 
		xp=getScreenWidth()-getWidth();
	if(xp<0) xp=0;

	/* Also control its objects( ie Weapons) */
	moveWeapons();
}
