#ifndef PLAYER_H
#define PLAYER_H

/* requires sprite.h, soul.h, weapon.h , entity.h */
#include "action.h"

const int NUMLIVES=3;

enum rail {FRONT,REAR,PORT,STARBOARD};

class
Player : public Entity
{
private:
	action dir;
	animList animLeft, animRight, animStr, animExp;
	Control* controller;
	Weapon* weapon[STARBOARD+1];		

	void init(void);
	void copy(const Player& p);
	void moveWeapons(void);
public:
	Player();
        Player(const Player& p);
        Player& operator=(const Player& p);

	void setControl( Control* c );
	void setWeapon( Weapon* w, rail r);
	void setDir(action d){dir=d;}

	void explode(void);
	void fire(void);
	/* Tests whether mounted weapons have hit anything */
	bool hit( const Sprite& e);
	void control(void);
	action getDir(void) const {return dir;}
};

#endif
