#include "btypes.h"
#include "sprite.h"
#include "weapon.h"
#include "projectile.h"
#include "effects.h"

extern int ticks;

Projectile :: Projectile( Sprite* anchor, int rate, int e, int m) 
{
	owner=anchor;
	firerate=rate;
	energy=e;
	maxproj=m;
}

void
Projectile:: setSlot(int s)
{
	for(int i=0;i<maxproj;i++)
		beam[i].setSlot(s);
}

void 
Projectile :: move(void)
{
	cerr << "moving proj\n";
        for(int i=0;i<maxproj;i++)
        {
                beam[i].move();
                if(beam[i].getYp() < 0)
			beam[i].disappear();
        }
}

void
Projectile :: fire(void)
{
	static int last=0;

	if(ticks - last > firerate)
	{ 
        	int i=0;
	        while(beam[i].getVisible()==1 && i<maxproj)
        	        i++;
	        if(i>=maxproj || beam[i].getVisible()==true)
                	return;
		sound(CHAN_PLAYER);
        	beam[i].setDelta(0,-2);
	        beam[i].setPos(owner->getXp()+owner->getWidth()/2-beam[i].getWidth()/2, owner->getYp()-beam[i].getHeight());
        	beam[i].appear();
		last=ticks;
	}
}

bool
Projectile :: collide(const Sprite& s)
{
	for(int i=0;i<maxproj;i++)
	{
		if(beam[i].getVisible())
		{
			if(beam[i].collide(s)) 
			{
				beam[i].disappear();
				return true;
			}
		}		
	}
	return false;
}

int
Projectile :: getEnergy( void ) const
{
	return energy;
}

void
Projectile :: replace (void)
{
	/* no need as popgun is a sprite! */
}

void
Projectile :: getBack (void)
{
	/* no need as popgun is a sprite! */
}

void
Projectile :: paste (void)
{
	/* no need as popgun is a sprite! */
}
