/*	Copyright Alex Hornby 1994/1995. All rights reserved.
 	See file README for details
*/

/* 2D starfield */

#include "starfield.h"
#include <iostream.h>
#include "rnd.h"
#include "btypes.h"
#include "palette.h"

extern Palette gamepal;

StarField::StarField() : Screen()
{
	for(int f=0; f<NUMFIELD; f++)
	{
		for(int s=0; s<NUMSTAR; s++)
		{
			pos[s][f].x=rnd(getScreenWidth());
			pos[s][f].y=rnd(getScreenHeight());
			speed[s][f]=rnd(MAXSPEED)+1;
		}
	}
	gamepal.allocate(0,0,0,0);
	for(int i=0;i<NUMFIELD;i++)
		color[i]=gamepal.request(48-6*i,48-6*i,48-6*i);
}

void 
StarField::getBack(void)
{
pixel *video;
	for(int f=0; f<NUMFIELD; f++)
	{
		for(int s=0; s<NUMSTAR; s++)
		{
		video= getGraphMem() + pos[s][f].x + pos[s][f].y * getScreenWidth();
		back[s][f]=*video;
		}
	}
}

void
StarField::replace(void)
{
	pixel *video;
	for(int f=0; f<NUMFIELD; f++)
	{
		for(int s=0; s<NUMSTAR; s++)
		{
		video= getGraphMem() + pos[s][f].x + pos[s][f].y * getScreenWidth();
		*video=back[s][f];
		}
	}
}

void
StarField::paste(void)
{
	pixel *video;
	for(int f=0; f<NUMFIELD; f++)
	{
		for(int s=0; s<NUMSTAR; s++)
		{
		video= getGraphMem() + pos[s][f].x + pos[s][f].y * getScreenWidth();
		*video=color[f];
		}
	}
}

void
StarField::update(void)
{
	replace();
	move();
	getBack();
	paste();
}

void
StarField::move(void)
{
	static int time;
	for(int f=0; f<NUMFIELD; f++)
	{
		if(time%(f+1)==0)
		{
			for(int s=0; s<NUMSTAR; s++)
			{
				pos[s][f].y+=speed[s][f];
				if(pos[s][f].y > getScreenHeight())
				{
					pos[s][f].x=rnd(getScreenWidth());
					pos[s][f].y=0;
					speed[s][f]=rnd(MAXSPEED)+1;
				}
			}
		}
	}
	time++;
}
